/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.settings.building;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.javax.inject.Singleton;
import io.quarkus.launcher.shaded.org.apache.maven.building.FileSource;
import io.quarkus.launcher.shaded.org.apache.maven.building.Source;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Settings;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.DefaultSettingsBuildingResult;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.DefaultSettingsProblemCollector;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsBuilder;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsBuildingException;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsBuildingRequest;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsBuildingResult;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsProblem;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsProblemCollector;
import io.quarkus.launcher.shaded.org.apache.maven.settings.io.SettingsParseException;
import io.quarkus.launcher.shaded.org.apache.maven.settings.io.SettingsReader;
import io.quarkus.launcher.shaded.org.apache.maven.settings.io.SettingsWriter;
import io.quarkus.launcher.shaded.org.apache.maven.settings.merge.MavenSettingsMerger;
import io.quarkus.launcher.shaded.org.apache.maven.settings.validation.SettingsValidator;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.InterpolationException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Named
@Singleton
public class DefaultSettingsBuilder
implements SettingsBuilder {
    private SettingsReader settingsReader;
    private SettingsWriter settingsWriter;
    private SettingsValidator settingsValidator;
    private final MavenSettingsMerger settingsMerger = new MavenSettingsMerger();

    @Inject
    public DefaultSettingsBuilder(SettingsReader settingsReader, SettingsWriter settingsWriter, SettingsValidator settingsValidator) {
        this.settingsReader = settingsReader;
        this.settingsWriter = settingsWriter;
        this.settingsValidator = settingsValidator;
    }

    public DefaultSettingsBuilder setSettingsReader(SettingsReader settingsReader) {
        this.settingsReader = settingsReader;
        return this;
    }

    public DefaultSettingsBuilder setSettingsWriter(SettingsWriter settingsWriter) {
        this.settingsWriter = settingsWriter;
        return this;
    }

    public DefaultSettingsBuilder setSettingsValidator(SettingsValidator settingsValidator) {
        this.settingsValidator = settingsValidator;
        return this;
    }

    @Override
    public SettingsBuildingResult build(SettingsBuildingRequest request) throws SettingsBuildingException {
        File file;
        DefaultSettingsProblemCollector problems = new DefaultSettingsProblemCollector(null);
        Source globalSettingsSource = this.getSettingsSource(request.getGlobalSettingsFile(), request.getGlobalSettingsSource());
        Settings globalSettings = this.readSettings(globalSettingsSource, request, problems);
        Source userSettingsSource = this.getSettingsSource(request.getUserSettingsFile(), request.getUserSettingsSource());
        Settings userSettings = this.readSettings(userSettingsSource, request, problems);
        this.settingsMerger.merge(userSettings, globalSettings, "io.quarkus.launcher.shaded.global-level");
        problems.setSource("io.quarkus.launcher.shaded.");
        userSettings = this.interpolate(userSettings, request, problems);
        String localRepository = userSettings.getLocalRepository();
        if (localRepository != null && localRepository.length() > 0 && !(file = new File(localRepository)).isAbsolute() && file.getPath().startsWith(File.separator)) {
            userSettings.setLocalRepository(file.getAbsolutePath());
        }
        if (this.hasErrors(problems.getProblems())) {
            throw new SettingsBuildingException(problems.getProblems());
        }
        return new DefaultSettingsBuildingResult(userSettings, problems.getProblems());
    }

    private boolean hasErrors(List<SettingsProblem> problems) {
        if (problems != null) {
            for (SettingsProblem problem : problems) {
                if (SettingsProblem.Severity.ERROR.compareTo(problem.getSeverity()) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private Source getSettingsSource(File settingsFile, Source settingsSource) {
        if (settingsSource != null) {
            return settingsSource;
        }
        if (settingsFile != null && settingsFile.exists()) {
            return new FileSource(settingsFile);
        }
        return null;
    }

    private Settings readSettings(Source settingsSource, SettingsBuildingRequest request, DefaultSettingsProblemCollector problems) {
        Settings settings;
        if (settingsSource == null) {
            return new Settings();
        }
        problems.setSource(settingsSource.getLocation());
        try {
            Map<String, Boolean> options = Collections.singletonMap("io.quarkus.launcher.shaded.org.apache.maven.settings.io.isStrict", Boolean.TRUE);
            try {
                settings = this.settingsReader.read(settingsSource.getInputStream(), options);
            }
            catch (SettingsParseException e) {
                options = Collections.singletonMap("io.quarkus.launcher.shaded.org.apache.maven.settings.io.isStrict", Boolean.FALSE);
                settings = this.settingsReader.read(settingsSource.getInputStream(), options);
                problems.add(SettingsProblem.Severity.WARNING, e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
            }
        }
        catch (SettingsParseException e) {
            problems.add(SettingsProblem.Severity.FATAL, "io.quarkus.launcher.shaded.Non-parseable settings " + settingsSource.getLocation() + "io.quarkus.launcher.shaded.: " + e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
            return new Settings();
        }
        catch (IOException e) {
            problems.add(SettingsProblem.Severity.FATAL, "io.quarkus.launcher.shaded.Non-readable settings " + settingsSource.getLocation() + "io.quarkus.launcher.shaded.: " + e.getMessage(), -1, -1, e);
            return new Settings();
        }
        this.settingsValidator.validate(settings, problems);
        return settings;
    }

    private Settings interpolate(Settings settings, SettingsBuildingRequest request, SettingsProblemCollector problems) {
        Settings result;
        StringWriter writer = new StringWriter(4096);
        try {
            this.settingsWriter.write(writer, null, settings);
        }
        catch (IOException e) {
            throw new IllegalStateException("io.quarkus.launcher.shaded.Failed to serialize settings to memory", e);
        }
        String serializedSettings = writer.toString();
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        interpolator.addValueSource(new PropertiesBasedValueSource(request.getUserProperties()));
        interpolator.addValueSource(new PropertiesBasedValueSource(request.getSystemProperties()));
        try {
            interpolator.addValueSource(new EnvarBasedValueSource());
        }
        catch (IOException e) {
            problems.add(SettingsProblem.Severity.WARNING, "io.quarkus.launcher.shaded.Failed to use environment variables for interpolation: " + e.getMessage(), -1, -1, e);
        }
        interpolator.addPostProcessor(new InterpolationPostProcessor(){

            @Override
            public Object execute(String expression, Object value) {
                if (value != null) {
                    value = value.toString().replace("io.quarkus.launcher.shaded.&", "io.quarkus.launcher.shaded.&amp;").replace("io.quarkus.launcher.shaded.<", "io.quarkus.launcher.shaded.&lt;").replace("io.quarkus.launcher.shaded.>", "io.quarkus.launcher.shaded.&gt;");
                    return value;
                }
                return null;
            }
        });
        try {
            serializedSettings = interpolator.interpolate(serializedSettings, "io.quarkus.launcher.shaded.settings");
        }
        catch (InterpolationException e) {
            problems.add(SettingsProblem.Severity.ERROR, "io.quarkus.launcher.shaded.Failed to interpolate settings: " + e.getMessage(), -1, -1, e);
            return settings;
        }
        try {
            Map<String, Boolean> options = Collections.singletonMap("io.quarkus.launcher.shaded.org.apache.maven.settings.io.isStrict", Boolean.FALSE);
            result = this.settingsReader.read(new StringReader(serializedSettings), options);
        }
        catch (IOException e) {
            problems.add(SettingsProblem.Severity.ERROR, "io.quarkus.launcher.shaded.Failed to interpolate settings: " + e.getMessage(), -1, -1, e);
            return settings;
        }
        return result;
    }
}

