/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.settings.building;

import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsProblem;

public class DefaultSettingsProblem
implements SettingsProblem {
    private final String source;
    private final int lineNumber;
    private final int columnNumber;
    private final String message;
    private final Exception exception;
    private final SettingsProblem.Severity severity;

    public DefaultSettingsProblem(String message, SettingsProblem.Severity severity, String source, int lineNumber, int columnNumber, Exception exception) {
        this.message = message;
        this.severity = severity != null ? severity : SettingsProblem.Severity.ERROR;
        this.source = source != null ? source : "io.quarkus.launcher.shaded.";
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.exception = exception;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public String getLocation() {
        StringBuilder buffer = new StringBuilder(256);
        if (this.getSource().length() > 0) {
            if (buffer.length() > 0) {
                buffer.append("io.quarkus.launcher.shaded., ");
            }
            buffer.append(this.getSource());
        }
        if (this.getLineNumber() > 0) {
            if (buffer.length() > 0) {
                buffer.append("io.quarkus.launcher.shaded., ");
            }
            buffer.append("io.quarkus.launcher.shaded.line ").append(this.getLineNumber());
        }
        if (this.getColumnNumber() > 0) {
            if (buffer.length() > 0) {
                buffer.append("io.quarkus.launcher.shaded., ");
            }
            buffer.append("io.quarkus.launcher.shaded.column ").append(this.getColumnNumber());
        }
        return buffer.toString();
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public String getMessage() {
        String msg;
        if (this.message != null && this.message.length() > 0) {
            msg = this.message;
        } else {
            msg = this.exception.getMessage();
            if (msg == null) {
                msg = "io.quarkus.launcher.shaded.";
            }
        }
        return msg;
    }

    @Override
    public SettingsProblem.Severity getSeverity() {
        return this.severity;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append('[').append((Object)this.getSeverity()).append("io.quarkus.launcher.shaded.] ");
        buffer.append(this.getMessage());
        buffer.append("io.quarkus.launcher.shaded. @ ").append(this.getLocation());
        return buffer.toString();
    }
}

