/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.settings.building;

import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsProblem;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class SettingsBuildingException
extends Exception {
    private final List<SettingsProblem> problems = new ArrayList<SettingsProblem>();

    public SettingsBuildingException(List<SettingsProblem> problems) {
        super(SettingsBuildingException.toMessage(problems));
        if (problems != null) {
            this.problems.addAll(problems);
        }
    }

    public List<SettingsProblem> getProblems() {
        return this.problems;
    }

    private static String toMessage(List<SettingsProblem> problems) {
        StringWriter buffer = new StringWriter(1024);
        PrintWriter writer = new PrintWriter(buffer);
        writer.print(problems.size());
        writer.print(problems.size() == 1 ? "io.quarkus.launcher.shaded. problem was " : "io.quarkus.launcher.shaded. problems were ");
        writer.print("io.quarkus.launcher.shaded.encountered while building the effective settings");
        writer.println();
        for (SettingsProblem problem : problems) {
            writer.print("io.quarkus.launcher.shaded.[");
            writer.print((Object)problem.getSeverity());
            writer.print("io.quarkus.launcher.shaded.] ");
            writer.print(problem.getMessage());
            writer.print("io.quarkus.launcher.shaded. @ ");
            writer.println(problem.getLocation());
        }
        return buffer.toString();
    }
}

