/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.settings.io;

import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.javax.inject.Singleton;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Settings;
import io.quarkus.launcher.shaded.org.apache.maven.settings.io.SettingsWriter;
import io.quarkus.launcher.shaded.org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.WriterFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;

@Named
@Singleton
public class DefaultSettingsWriter
implements SettingsWriter {
    @Override
    public void write(File output, Map<String, Object> options, Settings settings) throws IOException {
        Objects.requireNonNull(output, "io.quarkus.launcher.shaded.output cannot be null");
        Objects.requireNonNull(settings, "io.quarkus.launcher.shaded.settings cannot be null");
        output.getParentFile().mkdirs();
        this.write(WriterFactory.newXmlWriter(output), options, settings);
    }

    @Override
    public void write(Writer output, Map<String, Object> options, Settings settings) throws IOException {
        Objects.requireNonNull(output, "io.quarkus.launcher.shaded.output cannot be null");
        Objects.requireNonNull(settings, "io.quarkus.launcher.shaded.settings cannot be null");
        try (Writer out = output;){
            new SettingsXpp3Writer().write(out, settings);
        }
    }

    @Override
    public void write(OutputStream output, Map<String, Object> options, Settings settings) throws IOException {
        Objects.requireNonNull(output, "io.quarkus.launcher.shaded.output cannot be null");
        Objects.requireNonNull(settings, "io.quarkus.launcher.shaded.settings cannot be null");
        String encoding = settings.getModelEncoding();
        if (encoding == null || encoding.length() <= 0) {
            encoding = "io.quarkus.launcher.shaded.UTF-8";
        }
        try (OutputStreamWriter out = new OutputStreamWriter(output, encoding);){
            this.write(out, options, settings);
        }
    }
}

