/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.settings.io.xpp3;

import io.quarkus.launcher.shaded.org.apache.maven.settings.Activation;
import io.quarkus.launcher.shaded.org.apache.maven.settings.ActivationFile;
import io.quarkus.launcher.shaded.org.apache.maven.settings.ActivationOS;
import io.quarkus.launcher.shaded.org.apache.maven.settings.ActivationProperty;
import io.quarkus.launcher.shaded.org.apache.maven.settings.IdentifiableBase;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Mirror;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Profile;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Proxy;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Repository;
import io.quarkus.launcher.shaded.org.apache.maven.settings.RepositoryBase;
import io.quarkus.launcher.shaded.org.apache.maven.settings.RepositoryPolicy;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Server;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Settings;
import io.quarkus.launcher.shaded.org.apache.maven.settings.TrackableBase;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.Xpp3Dom;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.pull.MXSerializer;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.pull.XmlSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class SettingsXpp3Writer {
    private static final String NAMESPACE = null;
    private String fileComment = null;

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void write(Writer writer, Settings settings) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("io/quarkus/launcher/shaded/http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "io.quarkus.launcher.shaded.  ");
        serializer.setProperty("io/quarkus/launcher/shaded/http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "io.quarkus.launcher.shaded.\n");
        serializer.setOutput(writer);
        serializer.startDocument(settings.getModelEncoding(), null);
        this.writeSettings(settings, "io.quarkus.launcher.shaded.settings", serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, Settings settings) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("io/quarkus/launcher/shaded/http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "io.quarkus.launcher.shaded.  ");
        serializer.setProperty("io/quarkus/launcher/shaded/http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "io.quarkus.launcher.shaded.\n");
        serializer.setOutput(stream, settings.getModelEncoding());
        serializer.startDocument(settings.getModelEncoding(), null);
        this.writeSettings(settings, "io.quarkus.launcher.shaded.settings", serializer);
        serializer.endDocument();
    }

    private void writeActivation(Activation activation, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (activation.isActiveByDefault()) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.activeByDefault").text(String.valueOf(activation.isActiveByDefault())).endTag(NAMESPACE, "io.quarkus.launcher.shaded.activeByDefault");
        }
        if (activation.getJdk() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.jdk").text(activation.getJdk()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.jdk");
        }
        if (activation.getOs() != null) {
            this.writeActivationOS(activation.getOs(), "io.quarkus.launcher.shaded.os", serializer);
        }
        if (activation.getProperty() != null) {
            this.writeActivationProperty(activation.getProperty(), "io.quarkus.launcher.shaded.property", serializer);
        }
        if (activation.getFile() != null) {
            this.writeActivationFile(activation.getFile(), "io.quarkus.launcher.shaded.file", serializer);
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeActivationFile(ActivationFile activationFile, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (activationFile.getMissing() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.missing").text(activationFile.getMissing()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.missing");
        }
        if (activationFile.getExists() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.exists").text(activationFile.getExists()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.exists");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeActivationOS(ActivationOS activationOS, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (activationOS.getName() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.name").text(activationOS.getName()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.name");
        }
        if (activationOS.getFamily() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.family").text(activationOS.getFamily()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.family");
        }
        if (activationOS.getArch() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.arch").text(activationOS.getArch()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.arch");
        }
        if (activationOS.getVersion() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.version").text(activationOS.getVersion()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.version");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeActivationProperty(ActivationProperty activationProperty, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (activationProperty.getName() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.name").text(activationProperty.getName()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.name");
        }
        if (activationProperty.getValue() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.value").text(activationProperty.getValue()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.value");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeIdentifiableBase(IdentifiableBase identifiableBase, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (identifiableBase.getId() != null && !identifiableBase.getId().equals("io.quarkus.launcher.shaded.default")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.id").text(identifiableBase.getId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.id");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeMirror(Mirror mirror, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (mirror.getMirrorOf() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.mirrorOf").text(mirror.getMirrorOf()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.mirrorOf");
        }
        if (mirror.getName() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.name").text(mirror.getName()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.name");
        }
        if (mirror.getUrl() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.url").text(mirror.getUrl()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.url");
        }
        if (mirror.getLayout() != null && !mirror.getLayout().equals("io.quarkus.launcher.shaded.default")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.layout").text(mirror.getLayout()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.layout");
        }
        if (mirror.getMirrorOfLayouts() != null && !mirror.getMirrorOfLayouts().equals("io.quarkus.launcher.shaded.default,legacy")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.mirrorOfLayouts").text(mirror.getMirrorOfLayouts()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.mirrorOfLayouts");
        }
        if (mirror.getId() != null && !mirror.getId().equals("io.quarkus.launcher.shaded.default")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.id").text(mirror.getId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.id");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeProfile(Profile profile, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (profile.getActivation() != null) {
            this.writeActivation(profile.getActivation(), "io.quarkus.launcher.shaded.activation", serializer);
        }
        if (profile.getProperties() != null && profile.getProperties().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.properties");
            for (String string : profile.getProperties().keySet()) {
                String value = (String)profile.getProperties().get(string);
                serializer.startTag(NAMESPACE, string).text(value).endTag(NAMESPACE, string);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.properties");
        }
        if (profile.getRepositories() != null && profile.getRepositories().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.repositories");
            for (Repository repository : profile.getRepositories()) {
                this.writeRepository(repository, "io.quarkus.launcher.shaded.repository", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.repositories");
        }
        if (profile.getPluginRepositories() != null && profile.getPluginRepositories().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.pluginRepositories");
            for (Repository repository : profile.getPluginRepositories()) {
                this.writeRepository(repository, "io.quarkus.launcher.shaded.pluginRepository", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.pluginRepositories");
        }
        if (profile.getId() != null && !profile.getId().equals("io.quarkus.launcher.shaded.default")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.id").text(profile.getId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.id");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeProxy(Proxy proxy, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (!proxy.isActive()) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.active").text(String.valueOf(proxy.isActive())).endTag(NAMESPACE, "io.quarkus.launcher.shaded.active");
        }
        if (proxy.getProtocol() != null && !proxy.getProtocol().equals("io.quarkus.launcher.shaded.http")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.protocol").text(proxy.getProtocol()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.protocol");
        }
        if (proxy.getUsername() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.username").text(proxy.getUsername()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.username");
        }
        if (proxy.getPassword() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.password").text(proxy.getPassword()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.password");
        }
        if (proxy.getPort() != 8080) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.port").text(String.valueOf(proxy.getPort())).endTag(NAMESPACE, "io.quarkus.launcher.shaded.port");
        }
        if (proxy.getHost() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.host").text(proxy.getHost()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.host");
        }
        if (proxy.getNonProxyHosts() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.nonProxyHosts").text(proxy.getNonProxyHosts()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.nonProxyHosts");
        }
        if (proxy.getId() != null && !proxy.getId().equals("io.quarkus.launcher.shaded.default")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.id").text(proxy.getId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.id");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeRepository(Repository repository, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (repository.getReleases() != null) {
            this.writeRepositoryPolicy(repository.getReleases(), "io.quarkus.launcher.shaded.releases", serializer);
        }
        if (repository.getSnapshots() != null) {
            this.writeRepositoryPolicy(repository.getSnapshots(), "io.quarkus.launcher.shaded.snapshots", serializer);
        }
        if (repository.getId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.id").text(repository.getId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.id");
        }
        if (repository.getName() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.name").text(repository.getName()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.name");
        }
        if (repository.getUrl() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.url").text(repository.getUrl()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.url");
        }
        if (repository.getLayout() != null && !repository.getLayout().equals("io.quarkus.launcher.shaded.default")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.layout").text(repository.getLayout()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.layout");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeRepositoryBase(RepositoryBase repositoryBase, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (repositoryBase.getId() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.id").text(repositoryBase.getId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.id");
        }
        if (repositoryBase.getName() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.name").text(repositoryBase.getName()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.name");
        }
        if (repositoryBase.getUrl() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.url").text(repositoryBase.getUrl()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.url");
        }
        if (repositoryBase.getLayout() != null && !repositoryBase.getLayout().equals("io.quarkus.launcher.shaded.default")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.layout").text(repositoryBase.getLayout()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.layout");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeRepositoryPolicy(RepositoryPolicy repositoryPolicy, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (!repositoryPolicy.isEnabled()) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.enabled").text(String.valueOf(repositoryPolicy.isEnabled())).endTag(NAMESPACE, "io.quarkus.launcher.shaded.enabled");
        }
        if (repositoryPolicy.getUpdatePolicy() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.updatePolicy").text(repositoryPolicy.getUpdatePolicy()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.updatePolicy");
        }
        if (repositoryPolicy.getChecksumPolicy() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.checksumPolicy").text(repositoryPolicy.getChecksumPolicy()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.checksumPolicy");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeServer(Server server, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (server.getUsername() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.username").text(server.getUsername()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.username");
        }
        if (server.getPassword() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.password").text(server.getPassword()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.password");
        }
        if (server.getPrivateKey() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.privateKey").text(server.getPrivateKey()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.privateKey");
        }
        if (server.getPassphrase() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.passphrase").text(server.getPassphrase()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.passphrase");
        }
        if (server.getFilePermissions() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.filePermissions").text(server.getFilePermissions()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.filePermissions");
        }
        if (server.getDirectoryPermissions() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.directoryPermissions").text(server.getDirectoryPermissions()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.directoryPermissions");
        }
        if (server.getConfiguration() != null) {
            ((Xpp3Dom)server.getConfiguration()).writeToSerializer(NAMESPACE, serializer);
        }
        if (server.getId() != null && !server.getId().equals("io.quarkus.launcher.shaded.default")) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.id").text(server.getId()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.id");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeSettings(Settings settings, String tagName, XmlSerializer serializer) throws IOException {
        if (this.fileComment != null) {
            serializer.comment(this.fileComment);
        }
        serializer.setPrefix("io.quarkus.launcher.shaded.", "io/quarkus/launcher/shaded/http://maven.apache.org/SETTINGS/1.1.0");
        serializer.setPrefix("io.quarkus.launcher.shaded.xsi", "io/quarkus/launcher/shaded/http://www.w3.org/2001/XMLSchema-instance");
        serializer.startTag(NAMESPACE, tagName);
        serializer.attribute("io.quarkus.launcher.shaded.", "io.quarkus.launcher.shaded.xsi:schemaLocation", "io/quarkus/launcher/shaded/http://maven.apache.org/SETTINGS/1.1.0 http://maven.apache.org/xsd/settings-1.1.0.xsd");
        if (settings.getLocalRepository() != null) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.localRepository").text(settings.getLocalRepository()).endTag(NAMESPACE, "io.quarkus.launcher.shaded.localRepository");
        }
        if (!settings.isInteractiveMode()) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.interactiveMode").text(String.valueOf(settings.isInteractiveMode())).endTag(NAMESPACE, "io.quarkus.launcher.shaded.interactiveMode");
        }
        if (settings.isUsePluginRegistry()) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.usePluginRegistry").text(String.valueOf(settings.isUsePluginRegistry())).endTag(NAMESPACE, "io.quarkus.launcher.shaded.usePluginRegistry");
        }
        if (settings.isOffline()) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.offline").text(String.valueOf(settings.isOffline())).endTag(NAMESPACE, "io.quarkus.launcher.shaded.offline");
        }
        if (settings.getProxies() != null && settings.getProxies().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.proxies");
            for (Proxy proxy : settings.getProxies()) {
                this.writeProxy(proxy, "io.quarkus.launcher.shaded.proxy", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.proxies");
        }
        if (settings.getServers() != null && settings.getServers().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.servers");
            for (Server server : settings.getServers()) {
                this.writeServer(server, "io.quarkus.launcher.shaded.server", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.servers");
        }
        if (settings.getMirrors() != null && settings.getMirrors().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.mirrors");
            for (Mirror mirror : settings.getMirrors()) {
                this.writeMirror(mirror, "io.quarkus.launcher.shaded.mirror", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.mirrors");
        }
        if (settings.getProfiles() != null && settings.getProfiles().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.profiles");
            for (Profile profile : settings.getProfiles()) {
                this.writeProfile(profile, "io.quarkus.launcher.shaded.profile", serializer);
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.profiles");
        }
        if (settings.getActiveProfiles() != null && settings.getActiveProfiles().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.activeProfiles");
            for (String string : settings.getActiveProfiles()) {
                serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.activeProfile").text(string).endTag(NAMESPACE, "io.quarkus.launcher.shaded.activeProfile");
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.activeProfiles");
        }
        if (settings.getPluginGroups() != null && settings.getPluginGroups().size() > 0) {
            serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.pluginGroups");
            for (String string : settings.getPluginGroups()) {
                serializer.startTag(NAMESPACE, "io.quarkus.launcher.shaded.pluginGroup").text(string).endTag(NAMESPACE, "io.quarkus.launcher.shaded.pluginGroup");
            }
            serializer.endTag(NAMESPACE, "io.quarkus.launcher.shaded.pluginGroups");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeTrackableBase(TrackableBase trackableBase, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        serializer.endTag(NAMESPACE, tagName);
    }
}

