/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.settings.validation;

import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.javax.inject.Singleton;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Mirror;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Profile;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Proxy;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Repository;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Server;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Settings;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsProblem;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsProblemCollector;
import io.quarkus.launcher.shaded.org.apache.maven.settings.validation.SettingsValidator;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.StringUtils;
import java.util.HashSet;
import java.util.List;

@Named
@Singleton
public class DefaultSettingsValidator
implements SettingsValidator {
    private static final String ID_REGEX = "io.quarkus.launcher.shaded.[A-Za-z0-9_\\-.]+";
    private static final String ILLEGAL_FS_CHARS = "io/quarkus/launcher/shaded/\\/:\"<>|?*";
    private static final String ILLEGAL_REPO_ID_CHARS = "io/quarkus/launcher/shaded/\\/:\"<>|?*";

    @Override
    public void validate(Settings settings, SettingsProblemCollector problems) {
        List<Proxy> proxies;
        List<Profile> profiles;
        List<Mirror> mirrors;
        List<Server> servers;
        List<String> pluginGroups;
        if (settings.isUsePluginRegistry()) {
            DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.WARNING, "io.quarkus.launcher.shaded.usePluginRegistry", null, "io.quarkus.launcher.shaded.is deprecated and has no effect.");
        }
        if ((pluginGroups = settings.getPluginGroups()) != null) {
            for (int i = 0; i < pluginGroups.size(); ++i) {
                String pluginGroup = pluginGroups.get(i).trim();
                if (StringUtils.isBlank(pluginGroup)) {
                    DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.ERROR, "io.quarkus.launcher.shaded.pluginGroups.pluginGroup[" + i + "io.quarkus.launcher.shaded.]", null, "io.quarkus.launcher.shaded.must not be empty");
                    continue;
                }
                if (pluginGroup.matches(ID_REGEX)) continue;
                DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.ERROR, "io.quarkus.launcher.shaded.pluginGroups.pluginGroup[" + i + "io.quarkus.launcher.shaded.]", null, "io.quarkus.launcher.shaded.must denote a valid group id and match the pattern [A-Za-z0-9_\\-.]+");
            }
        }
        if ((servers = settings.getServers()) != null) {
            HashSet<String> serverIds = new HashSet<String>();
            for (int i = 0; i < servers.size(); ++i) {
                Server server = servers.get(i);
                DefaultSettingsValidator.validateStringNotEmpty(problems, "io.quarkus.launcher.shaded.servers.server[" + i + "io.quarkus.launcher.shaded.].id", server.getId(), null);
                if (serverIds.add(server.getId())) continue;
                DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.WARNING, "io.quarkus.launcher.shaded.servers.server.id", null, "io.quarkus.launcher.shaded.must be unique but found duplicate server with id " + server.getId());
            }
        }
        if ((mirrors = settings.getMirrors()) != null) {
            for (Mirror mirror : mirrors) {
                DefaultSettingsValidator.validateStringNotEmpty(problems, "io.quarkus.launcher.shaded.mirrors.mirror.id", mirror.getId(), mirror.getUrl());
                DefaultSettingsValidator.validateBannedCharacters(problems, "io.quarkus.launcher.shaded.mirrors.mirror.id", SettingsProblem.Severity.WARNING, mirror.getId(), null, "io/quarkus/launcher/shaded/\\/:\"<>|?*");
                if ("io.quarkus.launcher.shaded.local".equals(mirror.getId())) {
                    DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.WARNING, "io.quarkus.launcher.shaded.mirrors.mirror.id", null, "io.quarkus.launcher.shaded.must not be 'local', this identifier is reserved for the local repository, using it for other repositories will corrupt your repository metadata.");
                }
                DefaultSettingsValidator.validateStringNotEmpty(problems, "io.quarkus.launcher.shaded.mirrors.mirror.url", mirror.getUrl(), mirror.getId());
                DefaultSettingsValidator.validateStringNotEmpty(problems, "io.quarkus.launcher.shaded.mirrors.mirror.mirrorOf", mirror.getMirrorOf(), mirror.getId());
            }
        }
        if ((profiles = settings.getProfiles()) != null) {
            HashSet<String> profileIds = new HashSet<String>();
            for (Profile profile : profiles) {
                if (!profileIds.add(profile.getId())) {
                    DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.WARNING, "io.quarkus.launcher.shaded.profiles.profile.id", null, "io.quarkus.launcher.shaded.must be unique but found duplicate profile with id " + profile.getId());
                }
                String prefix = "io.quarkus.launcher.shaded.profiles.profile[" + profile.getId() + "io.quarkus.launcher.shaded.].";
                this.validateRepositories(problems, profile.getRepositories(), prefix + "io.quarkus.launcher.shaded.repositories.repository");
                this.validateRepositories(problems, profile.getPluginRepositories(), prefix + "io.quarkus.launcher.shaded.pluginRepositories.pluginRepository");
            }
        }
        if ((proxies = settings.getProxies()) != null) {
            HashSet<String> proxyIds = new HashSet<String>();
            for (Proxy proxy : proxies) {
                if (!proxyIds.add(proxy.getId())) {
                    DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.WARNING, "io.quarkus.launcher.shaded.proxies.proxy.id", null, "io.quarkus.launcher.shaded.must be unique but found duplicate proxy with id " + proxy.getId());
                }
                DefaultSettingsValidator.validateStringNotEmpty(problems, "io.quarkus.launcher.shaded.proxies.proxy.host", proxy.getHost(), proxy.getId());
            }
        }
    }

    private void validateRepositories(SettingsProblemCollector problems, List<Repository> repositories, String prefix) {
        HashSet<String> repoIds = new HashSet<String>();
        for (Repository repository : repositories) {
            DefaultSettingsValidator.validateStringNotEmpty(problems, prefix + "io.quarkus.launcher.shaded..id", repository.getId(), repository.getUrl());
            DefaultSettingsValidator.validateBannedCharacters(problems, prefix + "io.quarkus.launcher.shaded..id", SettingsProblem.Severity.WARNING, repository.getId(), null, "io/quarkus/launcher/shaded/\\/:\"<>|?*");
            if ("io.quarkus.launcher.shaded.local".equals(repository.getId())) {
                DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.WARNING, prefix + "io.quarkus.launcher.shaded..id", null, "io.quarkus.launcher.shaded.must not be 'local', this identifier is reserved for the local repository, using it for other repositories will corrupt your repository metadata.");
            }
            if (!repoIds.add(repository.getId())) {
                DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.WARNING, prefix + "io.quarkus.launcher.shaded..id", null, "io.quarkus.launcher.shaded.must be unique but found duplicate repository with id " + repository.getId());
            }
            DefaultSettingsValidator.validateStringNotEmpty(problems, prefix + "io.quarkus.launcher.shaded..url", repository.getUrl(), repository.getId());
            if (!"io.quarkus.launcher.shaded.legacy".equals(repository.getLayout())) continue;
            DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.WARNING, prefix + "io.quarkus.launcher.shaded..layout", repository.getId(), "io.quarkus.launcher.shaded.uses the unsupported value 'legacy', artifact resolution might fail.");
        }
    }

    private static boolean validateStringNotEmpty(SettingsProblemCollector problems, String fieldName, String string, String sourceHint) {
        if (!DefaultSettingsValidator.validateNotNull(problems, fieldName, string, sourceHint)) {
            return false;
        }
        if (string.length() > 0) {
            return true;
        }
        DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.ERROR, fieldName, sourceHint, "io.quarkus.launcher.shaded.is missing");
        return false;
    }

    private static boolean validateNotNull(SettingsProblemCollector problems, String fieldName, Object object, String sourceHint) {
        if (object != null) {
            return true;
        }
        DefaultSettingsValidator.addViolation(problems, SettingsProblem.Severity.ERROR, fieldName, sourceHint, "io.quarkus.launcher.shaded.is missing");
        return false;
    }

    private static boolean validateBannedCharacters(SettingsProblemCollector problems, String fieldName, SettingsProblem.Severity severity, String string, String sourceHint, String banned) {
        if (string != null) {
            for (int i = string.length() - 1; i >= 0; --i) {
                if (banned.indexOf(string.charAt(i)) < 0) continue;
                DefaultSettingsValidator.addViolation(problems, severity, fieldName, sourceHint, "io.quarkus.launcher.shaded.must not contain any of these characters " + banned + "io.quarkus.launcher.shaded. but found " + string.charAt(i));
                return false;
            }
        }
        return true;
    }

    private static void addViolation(SettingsProblemCollector problems, SettingsProblem.Severity severity, String fieldName, String sourceHint, String message) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append('\'').append(fieldName).append('\'');
        if (sourceHint != null) {
            buffer.append("io.quarkus.launcher.shaded. for ").append(sourceHint);
        }
        buffer.append(' ').append(message);
        problems.add(severity, buffer.toString(), -1, -1, null);
    }
}

