/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.shared.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class Os {
    public static final String OS_NAME = System.getProperty("io.quarkus.launcher.shaded.os.name").toLowerCase(Locale.ENGLISH);
    public static final String OS_ARCH = System.getProperty("io.quarkus.launcher.shaded.os.arch").toLowerCase(Locale.ENGLISH);
    public static final String OS_VERSION = System.getProperty("io.quarkus.launcher.shaded.os.version").toLowerCase(Locale.ENGLISH);
    public static final String PATH_SEP = System.getProperty("io.quarkus.launcher.shaded.path.separator");
    public static final String LINE_SEP = System.getProperty("io.quarkus.launcher.shaded.line.separator");
    public static final String OS_FAMILY = Os.getOsFamily();
    private static final Set<String> VALID_FAMILIES = Os.getValidFamilies();
    private String family;
    public static final String FAMILY_WINDOWS = "io.quarkus.launcher.shaded.windows";
    public static final String FAMILY_WIN9X = "io.quarkus.launcher.shaded.win9x";
    public static final String FAMILY_NT = "io.quarkus.launcher.shaded.winnt";
    public static final String FAMILY_OS2 = "io/quarkus/launcher/shaded/os/2";
    public static final String FAMILY_NETWARE = "io.quarkus.launcher.shaded.netware";
    public static final String FAMILY_DOS = "io.quarkus.launcher.shaded.dos";
    public static final String FAMILY_MAC = "io.quarkus.launcher.shaded.mac";
    public static final String FAMILY_TANDEM = "io.quarkus.launcher.shaded.tandem";
    public static final String FAMILY_UNIX = "io.quarkus.launcher.shaded.unix";
    public static final String FAMILY_OPENVMS = "io.quarkus.launcher.shaded.openvms";
    public static final String FAMILY_ZOS = "io/quarkus/launcher/shaded/z/os";
    public static final String FAMILY_OS400 = "io/quarkus/launcher/shaded/os/400";
    private static final String DARWIN = "io.quarkus.launcher.shaded.darwin";

    public static Set<String> getValidFamilies() {
        if (VALID_FAMILIES != null) {
            return VALID_FAMILIES;
        }
        HashSet<String> valid = new HashSet<String>();
        valid.add(FAMILY_DOS);
        valid.add(FAMILY_MAC);
        valid.add(FAMILY_NETWARE);
        valid.add(FAMILY_NT);
        valid.add(FAMILY_OPENVMS);
        valid.add(FAMILY_OS2);
        valid.add(FAMILY_OS400);
        valid.add(FAMILY_TANDEM);
        valid.add(FAMILY_UNIX);
        valid.add(FAMILY_WIN9X);
        valid.add(FAMILY_WINDOWS);
        valid.add(FAMILY_ZOS);
        return Collections.unmodifiableSet(valid);
    }

    public Os() {
    }

    public Os(String family) {
        this.setFamily(family);
    }

    private void setFamily(String f) {
        this.family = f.toLowerCase(Locale.ENGLISH);
    }

    boolean eval() {
        return Os.isOs(this.family, null, null, null);
    }

    public static boolean isFamily(String family) {
        return Os.isOs(family, null, null, null);
    }

    public static boolean isName(String name) {
        return Os.isOs(null, name, null, null);
    }

    public static boolean isArch(String arch) {
        return Os.isOs(null, null, arch, null);
    }

    public static boolean isVersion(String version) {
        return Os.isOs(null, null, null, version);
    }

    private static boolean isOs(String family, String name, String arch, String version) {
        boolean retValue = false;
        if (family != null || name != null || arch != null || version != null) {
            boolean isFamily = true;
            boolean isName = true;
            boolean isArch = true;
            boolean isVersion = true;
            if (family != null) {
                boolean isWindows = OS_NAME.contains(FAMILY_WINDOWS);
                boolean is9x = false;
                boolean isNT = false;
                if (isWindows) {
                    is9x = OS_NAME.contains("io.quarkus.launcher.shaded.95") || OS_NAME.contains("io.quarkus.launcher.shaded.98") || OS_NAME.contains("io.quarkus.launcher.shaded.me") || OS_NAME.contains("io.quarkus.launcher.shaded.ce");
                    boolean bl = isNT = !is9x;
                }
                isFamily = family.equals(FAMILY_WINDOWS) ? isWindows : (family.equals(FAMILY_WIN9X) ? isWindows && is9x : (family.equals(FAMILY_NT) ? isWindows && isNT : (family.equals(FAMILY_OS2) ? OS_NAME.contains(FAMILY_OS2) : (family.equals(FAMILY_NETWARE) ? OS_NAME.contains(FAMILY_NETWARE) : (family.equals(FAMILY_DOS) ? PATH_SEP.equals("io.quarkus.launcher.shaded.;") && !Os.isFamily(FAMILY_NETWARE) : (family.equals(FAMILY_MAC) ? OS_NAME.contains(FAMILY_MAC) || OS_NAME.contains(DARWIN) : (family.equals(FAMILY_TANDEM) ? OS_NAME.contains("io.quarkus.launcher.shaded.nonstop_kernel") : (family.equals(FAMILY_UNIX) ? PATH_SEP.equals("io.quarkus.launcher.shaded.:") && !Os.isFamily(FAMILY_OPENVMS) && (!Os.isFamily(FAMILY_MAC) || OS_NAME.endsWith("io.quarkus.launcher.shaded.x") || OS_NAME.contains(DARWIN)) : (family.equals(FAMILY_ZOS) ? OS_NAME.contains(FAMILY_ZOS) || OS_NAME.contains("io/quarkus/launcher/shaded/os/390") : (family.equals(FAMILY_OS400) ? OS_NAME.contains(FAMILY_OS400) : (family.equals(FAMILY_OPENVMS) ? OS_NAME.contains(FAMILY_OPENVMS) : OS_NAME.contains(family.toLowerCase(Locale.US)))))))))))));
            }
            if (name != null) {
                isName = name.equals(OS_NAME);
            }
            if (arch != null) {
                isArch = arch.equals(OS_ARCH);
            }
            if (version != null) {
                isVersion = version.equals(OS_VERSION);
            }
            retValue = isFamily && isName && isArch && isVersion;
        }
        return retValue;
    }

    private static String getOsFamily() {
        Set<String> families = Os.getValidFamilies();
        for (String fam : families) {
            if (!Os.isFamily(fam)) continue;
            return fam;
        }
        return null;
    }

    public static boolean isValidFamily(String family) {
        return VALID_FAMILIES.contains(family);
    }
}

