/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.shared.utils;

import io.quarkus.launcher.shaded.javax.annotation.Nonnull;
import io.quarkus.launcher.shaded.org.apache.commons.io.input.XmlStreamReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;

public class ReaderFactory {
    public static final String ISO_8859_1 = "io.quarkus.launcher.shaded.ISO-8859-1";
    public static final String US_ASCII = "io.quarkus.launcher.shaded.US-ASCII";
    public static final String UTF_16 = "io.quarkus.launcher.shaded.UTF-16";
    public static final String UTF_16BE = "io.quarkus.launcher.shaded.UTF-16BE";
    public static final String UTF_16LE = "io.quarkus.launcher.shaded.UTF-16LE";
    public static final String UTF_8 = "io.quarkus.launcher.shaded.UTF-8";
    public static final String FILE_ENCODING = System.getProperty("io.quarkus.launcher.shaded.file.encoding");

    public static Reader newXmlReader(@Nonnull InputStream in) throws IOException {
        return new XmlStreamReader(in);
    }

    public static Reader newXmlReader(@Nonnull File file) throws IOException {
        return new XmlStreamReader(file);
    }

    public static Reader newXmlReader(@Nonnull URL url) throws IOException {
        return new XmlStreamReader(url);
    }

    public static Reader newPlatformReader(@Nonnull File file) throws FileNotFoundException {
        return new FileReader(file);
    }

    public static Reader newReader(@Nonnull InputStream in, @Nonnull String encoding) throws UnsupportedEncodingException {
        return new InputStreamReader(in, encoding);
    }

    public static Reader newReader(@Nonnull File file, @Nonnull String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        return new InputStreamReader((InputStream)new FileInputStream(file), encoding);
    }

    public static Reader newReader(@Nonnull URL url, @Nonnull String encoding) throws IOException {
        return new InputStreamReader(url.openStream(), encoding);
    }
}

