/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.shared.utils;

import io.quarkus.launcher.shaded.javax.annotation.Nonnull;
import io.quarkus.launcher.shaded.org.apache.maven.shared.utils.xml.XmlStreamWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class WriterFactory {
    public static final String ISO_8859_1 = "io.quarkus.launcher.shaded.ISO-8859-1";
    public static final String US_ASCII = "io.quarkus.launcher.shaded.US-ASCII";
    public static final String UTF_16 = "io.quarkus.launcher.shaded.UTF-16";
    public static final String UTF_16BE = "io.quarkus.launcher.shaded.UTF-16BE";
    public static final String UTF_16LE = "io.quarkus.launcher.shaded.UTF-16LE";
    public static final String UTF_8 = "io.quarkus.launcher.shaded.UTF-8";
    public static final String FILE_ENCODING = System.getProperty("io.quarkus.launcher.shaded.file.encoding");

    public static XmlStreamWriter newXmlWriter(@Nonnull OutputStream out) throws IOException {
        return new XmlStreamWriter(out);
    }

    public static XmlStreamWriter newXmlWriter(@Nonnull File file) throws IOException {
        return new XmlStreamWriter(file);
    }

    public static Writer newPlatformWriter(@Nonnull OutputStream out) {
        return new OutputStreamWriter(out);
    }

    public static Writer newPlatformWriter(@Nonnull File file) throws IOException {
        return new FileWriter(file);
    }

    public static Writer newWriter(@Nonnull OutputStream out, @Nonnull String encoding) throws UnsupportedEncodingException {
        return new OutputStreamWriter(out, encoding);
    }

    public static Writer newWriter(@Nonnull File file, @Nonnull String encoding) throws UnsupportedEncodingException, FileNotFoundException {
        return WriterFactory.newWriter(new FileOutputStream(file), encoding);
    }
}

