/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.shared.utils.io;

import io.quarkus.launcher.shaded.javax.annotation.Nonnull;
import io.quarkus.launcher.shaded.javax.annotation.Nullable;
import io.quarkus.launcher.shaded.org.apache.maven.shared.utils.io.DirectoryScanResult;
import io.quarkus.launcher.shaded.org.apache.maven.shared.utils.io.Java7Support;
import io.quarkus.launcher.shaded.org.apache.maven.shared.utils.io.MatchPatterns;
import io.quarkus.launcher.shaded.org.apache.maven.shared.utils.io.ScanConductor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DirectoryScanner {
    public static final String[] DEFAULTEXCLUDES = new String[]{"io/quarkus/launcher/shaded/**/*~", "io/quarkus/launcher/shaded/**/#*#", "io/quarkus/launcher/shaded/**/.#*", "io/quarkus/launcher/shaded/**/%*%", "io/quarkus/launcher/shaded/**/._*", "io/quarkus/launcher/shaded/**/CVS", "io/quarkus/launcher/shaded/**/CVS/**", "io/quarkus/launcher/shaded/**/.cvsignore", "io/quarkus/launcher/shaded/**/.svn", "io/quarkus/launcher/shaded/**/.svn/**", "io/quarkus/launcher/shaded/**/.arch-ids", "io/quarkus/launcher/shaded/**/.arch-ids/**", "io/quarkus/launcher/shaded/**/.bzr", "io/quarkus/launcher/shaded/**/.bzr/**", "io/quarkus/launcher/shaded/**/.MySCMServerInfo", "io/quarkus/launcher/shaded/**/.DS_Store", "io/quarkus/launcher/shaded/**/.metadata", "io/quarkus/launcher/shaded/**/.metadata/**", "io/quarkus/launcher/shaded/**/.hg", "io/quarkus/launcher/shaded/**/.hg/**", "io/quarkus/launcher/shaded/**/.git", "io/quarkus/launcher/shaded/**/.git/**", "io/quarkus/launcher/shaded/**/BitKeeper", "io/quarkus/launcher/shaded/**/BitKeeper/**", "io/quarkus/launcher/shaded/**/ChangeSet", "io/quarkus/launcher/shaded/**/ChangeSet/**", "io/quarkus/launcher/shaded/**/_darcs", "io/quarkus/launcher/shaded/**/_darcs/**", "io/quarkus/launcher/shaded/**/.darcsrepo", "io/quarkus/launcher/shaded/**/.darcsrepo/**", "io/quarkus/launcher/shaded/**/-darcs-backup*", "io/quarkus/launcher/shaded/**/.darcs-temp-mail"};
    private File basedir;
    private String[] includes;
    private String[] excludes;
    private MatchPatterns excludesPatterns;
    private MatchPatterns includesPatterns;
    private List<String> filesIncluded;
    private List<String> filesNotIncluded;
    private List<String> filesExcluded;
    private List<String> dirsIncluded;
    private List<String> dirsNotIncluded;
    private List<String> dirsExcluded;
    private boolean haveSlowResults = false;
    private boolean isCaseSensitive = true;
    private boolean followSymlinks = true;
    private ScanConductor scanConductor = null;
    private ScanConductor.ScanAction scanAction = null;

    public void setBasedir(String basedir) {
        this.setBasedir(new File(basedir.replace('/', File.separatorChar).replace('\\', File.separatorChar)));
    }

    public void setBasedir(@Nonnull File basedir) {
        this.basedir = basedir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setCaseSensitive(boolean isCaseSensitiveParameter) {
        this.isCaseSensitive = isCaseSensitiveParameter;
    }

    public void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    public void setIncludes(String ... includes) {
        if (includes == null) {
            this.includes = null;
        } else {
            this.includes = new String[includes.length];
            for (int i = 0; i < includes.length; ++i) {
                String pattern = includes[i].trim().replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (pattern.endsWith(File.separator)) {
                    pattern = pattern + "io.quarkus.launcher.shaded.**";
                }
                this.includes[i] = pattern;
            }
        }
    }

    public void setExcludes(String ... excludes) {
        if (excludes == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[excludes.length];
            for (int i = 0; i < excludes.length; ++i) {
                String pattern = excludes[i].trim().replace('/', File.separatorChar).replace('\\', File.separatorChar);
                if (pattern.endsWith(File.separator)) {
                    pattern = pattern + "io.quarkus.launcher.shaded.**";
                }
                this.excludes[i] = pattern;
            }
        }
    }

    public void setScanConductor(ScanConductor scanConductor) {
        this.scanConductor = scanConductor;
    }

    public void scan() throws IllegalStateException {
        if (this.basedir == null) {
            throw new IllegalStateException("io.quarkus.launcher.shaded.No basedir set");
        }
        if (!this.basedir.exists()) {
            throw new IllegalStateException("io.quarkus.launcher.shaded.basedir " + this.basedir + "io.quarkus.launcher.shaded. does not exist");
        }
        if (!this.basedir.isDirectory()) {
            throw new IllegalStateException("io.quarkus.launcher.shaded.basedir " + this.basedir + "io.quarkus.launcher.shaded. is not a directory");
        }
        this.setupDefaultFilters();
        this.setupMatchPatterns();
        this.filesIncluded = new ArrayList<String>();
        this.filesNotIncluded = new ArrayList<String>();
        this.filesExcluded = new ArrayList<String>();
        this.dirsIncluded = new ArrayList<String>();
        this.dirsNotIncluded = new ArrayList<String>();
        this.dirsExcluded = new ArrayList<String>();
        this.scanAction = ScanConductor.ScanAction.CONTINUE;
        if (this.isIncluded("io.quarkus.launcher.shaded.")) {
            if (!this.isExcluded("io.quarkus.launcher.shaded.")) {
                if (this.scanConductor != null) {
                    this.scanAction = this.scanConductor.visitDirectory("io.quarkus.launcher.shaded.", this.basedir);
                    if (ScanConductor.ScanAction.ABORT.equals((Object)this.scanAction) || ScanConductor.ScanAction.ABORT_DIRECTORY.equals((Object)this.scanAction) || ScanConductor.ScanAction.NO_RECURSE.equals((Object)this.scanAction)) {
                        return;
                    }
                }
                this.dirsIncluded.add("io.quarkus.launcher.shaded.");
            } else {
                this.dirsExcluded.add("io.quarkus.launcher.shaded.");
            }
        } else {
            this.dirsNotIncluded.add("io.quarkus.launcher.shaded.");
        }
        this.scandir(this.basedir, "io.quarkus.launcher.shaded.", true);
    }

    public DirectoryScanResult diffIncludedFiles(String ... oldFiles) {
        if (this.filesIncluded == null) {
            this.scan();
        }
        return DirectoryScanner.diffFiles(oldFiles, this.filesIncluded.toArray(new String[this.filesIncluded.size()]));
    }

    public static DirectoryScanResult diffFiles(@Nullable String[] oldFiles, @Nullable String[] newFiles) {
        Set<String> oldFileSet = DirectoryScanner.arrayAsHashSet(oldFiles);
        Set<String> newFileSet = DirectoryScanner.arrayAsHashSet(newFiles);
        ArrayList<String> added = new ArrayList<String>();
        ArrayList<String> removed = new ArrayList<String>();
        for (String oldFile : oldFileSet) {
            if (newFileSet.contains(oldFile)) continue;
            removed.add(oldFile);
        }
        for (String newFile : newFileSet) {
            if (oldFileSet.contains(newFile)) continue;
            added.add(newFile);
        }
        String[] filesAdded = added.toArray(new String[added.size()]);
        String[] filesRemoved = removed.toArray(new String[removed.size()]);
        return new DirectoryScanResult(filesAdded, filesRemoved);
    }

    private static <T> Set<T> arrayAsHashSet(@Nullable T[] array) {
        if (array == null || array.length == 0) {
            return Collections.emptySet();
        }
        HashSet set = new HashSet(array.length);
        Collections.addAll(set, array);
        return set;
    }

    void slowScan() {
        if (this.haveSlowResults) {
            return;
        }
        String[] excl = this.dirsExcluded.toArray(new String[this.dirsExcluded.size()]);
        String[] notIncl = this.dirsNotIncluded.toArray(new String[this.dirsNotIncluded.size()]);
        for (String anExcl : excl) {
            if (this.couldHoldIncluded(anExcl)) continue;
            this.scandir(new File(this.basedir, anExcl), anExcl + File.separator, false);
        }
        for (String aNotIncl : notIncl) {
            if (this.couldHoldIncluded(aNotIncl)) continue;
            this.scandir(new File(this.basedir, aNotIncl), aNotIncl + File.separator, false);
        }
        this.haveSlowResults = true;
    }

    void scandir(@Nonnull File dir, @Nonnull String vpath, boolean fast) {
        String[] newfiles = dir.list();
        if (newfiles == null) {
            newfiles = new String[]{};
        }
        if (!this.followSymlinks) {
            newfiles = this.doNotFollowSymbolicLinks(dir, vpath, newfiles);
        }
        for (String newfile : newfiles) {
            String name = vpath + newfile;
            File file = new File(dir, newfile);
            if (file.isDirectory()) {
                if (this.isIncluded(name)) {
                    if (!this.isExcluded(name)) {
                        if (this.scanConductor != null) {
                            this.scanAction = this.scanConductor.visitDirectory(name, file);
                            if (ScanConductor.ScanAction.ABORT.equals((Object)this.scanAction) || ScanConductor.ScanAction.ABORT_DIRECTORY.equals((Object)this.scanAction)) {
                                return;
                            }
                        }
                        if (!ScanConductor.ScanAction.NO_RECURSE.equals((Object)this.scanAction)) {
                            this.dirsIncluded.add(name);
                            if (fast) {
                                this.scandir(file, name + File.separator, fast);
                                if (ScanConductor.ScanAction.ABORT.equals((Object)this.scanAction)) {
                                    return;
                                }
                            }
                        }
                        this.scanAction = null;
                    } else {
                        this.dirsExcluded.add(name);
                        if (fast && this.couldHoldIncluded(name)) {
                            this.scandir(file, name + File.separator, fast);
                            if (ScanConductor.ScanAction.ABORT.equals((Object)this.scanAction)) {
                                return;
                            }
                            this.scanAction = null;
                        }
                    }
                } else if (fast && this.couldHoldIncluded(name)) {
                    if (this.scanConductor != null) {
                        this.scanAction = this.scanConductor.visitDirectory(name, file);
                        if (ScanConductor.ScanAction.ABORT.equals((Object)this.scanAction) || ScanConductor.ScanAction.ABORT_DIRECTORY.equals((Object)this.scanAction)) {
                            return;
                        }
                    }
                    if (!ScanConductor.ScanAction.NO_RECURSE.equals((Object)this.scanAction)) {
                        this.dirsNotIncluded.add(name);
                        this.scandir(file, name + File.separator, fast);
                        if (ScanConductor.ScanAction.ABORT.equals((Object)this.scanAction)) {
                            return;
                        }
                    }
                    this.scanAction = null;
                }
                if (fast) continue;
                this.scandir(file, name + File.separator, fast);
                if (ScanConductor.ScanAction.ABORT.equals((Object)this.scanAction)) {
                    return;
                }
                this.scanAction = null;
                continue;
            }
            if (!file.isFile()) continue;
            if (this.isIncluded(name)) {
                if (!this.isExcluded(name)) {
                    if (this.scanConductor != null) {
                        this.scanAction = this.scanConductor.visitFile(name, file);
                    }
                    if (ScanConductor.ScanAction.ABORT.equals((Object)this.scanAction) || ScanConductor.ScanAction.ABORT_DIRECTORY.equals((Object)this.scanAction)) {
                        return;
                    }
                    this.filesIncluded.add(name);
                    continue;
                }
                this.filesExcluded.add(name);
                continue;
            }
            this.filesNotIncluded.add(name);
        }
    }

    private String[] doNotFollowSymbolicLinks(File dir, String vpath, String[] newfiles) {
        ArrayList<String> noLinks = new ArrayList<String>();
        for (String newfile : newfiles) {
            try {
                if (this.isSymbolicLink(dir, newfile)) {
                    String name = vpath + newfile;
                    File file = new File(dir, newfile);
                    if (file.isDirectory()) {
                        this.dirsExcluded.add(name);
                        continue;
                    }
                    this.filesExcluded.add(name);
                    continue;
                }
                noLinks.add(newfile);
            }
            catch (IOException ioe) {
                String msg = "io.quarkus.launcher.shaded.IOException caught while checking for links, couldn't get cannonical path!";
                System.err.println("io.quarkus.launcher.shaded.IOException caught while checking for links, couldn't get cannonical path!");
                noLinks.add(newfile);
            }
        }
        newfiles = noLinks.toArray(new String[noLinks.size()]);
        return newfiles;
    }

    boolean isIncluded(String name) {
        return this.includesPatterns.matches(name, this.isCaseSensitive);
    }

    boolean couldHoldIncluded(@Nonnull String name) {
        return this.includesPatterns.matchesPatternStart(name, this.isCaseSensitive);
    }

    boolean isExcluded(@Nonnull String name) {
        return this.excludesPatterns.matches(name, this.isCaseSensitive);
    }

    public String[] getIncludedFiles() {
        if (this.filesIncluded == null) {
            return new String[0];
        }
        return this.filesIncluded.toArray(new String[this.filesIncluded.size()]);
    }

    public String[] getNotIncludedFiles() {
        this.slowScan();
        return this.filesNotIncluded.toArray(new String[this.filesNotIncluded.size()]);
    }

    public String[] getExcludedFiles() {
        this.slowScan();
        return this.filesExcluded.toArray(new String[this.filesExcluded.size()]);
    }

    public String[] getIncludedDirectories() {
        return this.dirsIncluded.toArray(new String[this.dirsIncluded.size()]);
    }

    public String[] getNotIncludedDirectories() {
        this.slowScan();
        return this.dirsNotIncluded.toArray(new String[this.dirsNotIncluded.size()]);
    }

    public String[] getExcludedDirectories() {
        this.slowScan();
        return this.dirsExcluded.toArray(new String[this.dirsExcluded.size()]);
    }

    public void addDefaultExcludes() {
        int excludesLength = this.excludes == null ? 0 : this.excludes.length;
        String[] newExcludes = new String[excludesLength + DEFAULTEXCLUDES.length];
        if (excludesLength > 0) {
            System.arraycopy(this.excludes, 0, newExcludes, 0, excludesLength);
        }
        for (int i = 0; i < DEFAULTEXCLUDES.length; ++i) {
            newExcludes[i + excludesLength] = DEFAULTEXCLUDES[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
        }
        this.excludes = newExcludes;
    }

    boolean isSymbolicLink(File parent, String name) throws IOException {
        if (Java7Support.isAtLeastJava7()) {
            return Java7Support.isSymLink(parent);
        }
        File resolvedParent = new File(parent.getCanonicalPath());
        File toTest = new File(resolvedParent, name);
        return !toTest.getAbsolutePath().equals(toTest.getCanonicalPath());
    }

    private void setupDefaultFilters() {
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "io.quarkus.launcher.shaded.**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
    }

    private void setupMatchPatterns() {
        this.includesPatterns = MatchPatterns.from(this.includes);
        this.excludesPatterns = MatchPatterns.from(this.excludes);
    }
}

