/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.shared.utils.io;

import io.quarkus.launcher.shaded.javax.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Java7Support {
    private static final boolean IS_JAVA7;
    private static Method isSymbolicLink;
    private static Method delete;
    private static Method toPath;
    private static Method exists;
    private static Method toFile;
    private static Method readSymlink;
    private static Method createSymlink;
    private static Object emptyLinkOpts;
    private static Object emptyFileAttributes;

    public static boolean isSymLink(@Nonnull File file) {
        try {
            Object path = toPath.invoke((Object)file, new Object[0]);
            return (Boolean)isSymbolicLink.invoke(null, path);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static File readSymbolicLink(@Nonnull File symlink) throws IOException {
        try {
            Object path = toPath.invoke((Object)symlink, new Object[0]);
            Object resultPath = readSymlink.invoke(null, path);
            return (File)toFile.invoke(resultPath, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean exists(@Nonnull File file) throws IOException {
        try {
            Object path = toPath.invoke((Object)file, new Object[0]);
            Object invoke = exists.invoke(null, path, emptyLinkOpts);
            return (Boolean)invoke;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)e.getTargetException();
        }
    }

    @Nonnull
    public static File createSymbolicLink(@Nonnull File symlink, @Nonnull File target) throws IOException {
        try {
            if (!Java7Support.exists(symlink)) {
                Object link = toPath.invoke((Object)symlink, new Object[0]);
                Object path = createSymlink.invoke(null, link, toPath.invoke((Object)target, new Object[0]), emptyFileAttributes);
                return (File)toFile.invoke(path, new Object[0]);
            }
            return symlink;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof IOException) {
                throw (IOException)targetException;
            }
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            throw new IOException(targetException.getClass() + "io.quarkus.launcher.shaded.: " + targetException.getLocalizedMessage());
        }
    }

    public static void delete(@Nonnull File file) throws IOException {
        try {
            Object path = toPath.invoke((Object)file, new Object[0]);
            delete.invoke(null, path);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw (IOException)e.getTargetException();
        }
    }

    public static boolean isJava7() {
        return IS_JAVA7;
    }

    public static boolean isAtLeastJava7() {
        return IS_JAVA7;
    }

    static {
        boolean isJava7x = true;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> files = cl.loadClass("io/quarkus/launcher/shaded/java.nio.file.Files");
            Class<?> path = cl.loadClass("io/quarkus/launcher/shaded/java.nio.file.Path");
            Class<?> fa = cl.loadClass("io/quarkus/launcher/shaded/java.nio.file.attribute.FileAttribute");
            Class<?> linkOption = cl.loadClass("io/quarkus/launcher/shaded/java.nio.file.LinkOption");
            isSymbolicLink = files.getMethod("io.quarkus.launcher.shaded.isSymbolicLink", path);
            delete = files.getMethod("io.quarkus.launcher.shaded.delete", path);
            readSymlink = files.getMethod("io.quarkus.launcher.shaded.readSymbolicLink", path);
            Object o = emptyFileAttributes = Array.newInstance(fa, 0);
            createSymlink = files.getMethod("io.quarkus.launcher.shaded.createSymbolicLink", path, path, o.getClass());
            emptyLinkOpts = Array.newInstance(linkOption, 0);
            exists = files.getMethod("io.quarkus.launcher.shaded.exists", path, emptyLinkOpts.getClass());
            toPath = File.class.getMethod("io.quarkus.launcher.shaded.toPath", new Class[0]);
            toFile = path.getMethod("io.quarkus.launcher.shaded.toFile", new Class[0]);
        }
        catch (ClassNotFoundException e) {
            isJava7x = false;
        }
        catch (NoSuchMethodException e) {
            isJava7x = false;
        }
        IS_JAVA7 = isJava7x;
    }
}

