/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.shared.utils.io;

import io.quarkus.launcher.shaded.javax.annotation.Nonnull;
import io.quarkus.launcher.shaded.org.apache.maven.shared.utils.io.SelectorUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class MatchPattern {
    private final String source;
    private final String regexPattern;
    private final Pattern regexPatternRegex;
    private final String separator;
    private final String[] tokenized;

    private MatchPattern(@Nonnull String source, @Nonnull String separator) {
        this.regexPattern = SelectorUtils.isRegexPrefixedPattern(source) ? source.substring("io.quarkus.launcher.shaded.%regex[".length(), source.length() - "io.quarkus.launcher.shaded.]".length()) : null;
        this.regexPatternRegex = this.regexPattern != null ? Pattern.compile(this.regexPattern) : null;
        this.source = SelectorUtils.isAntPrefixedPattern(source) ? source.substring("io.quarkus.launcher.shaded.%ant[".length(), source.length() - "io.quarkus.launcher.shaded.]".length()) : source;
        this.separator = separator;
        this.tokenized = MatchPattern.tokenizePathToString(this.source, separator);
    }

    public boolean matchPath(String str, boolean isCaseSensitive) {
        if (this.regexPattern != null) {
            return this.regexPatternRegex.matcher(str).matches();
        }
        return SelectorUtils.matchAntPathPattern(this, str, this.separator, isCaseSensitive);
    }

    boolean matchPath(String str, String[] strDirs, boolean isCaseSensitive) {
        if (this.regexPattern != null) {
            return this.regexPatternRegex.matcher(str).matches();
        }
        return SelectorUtils.matchAntPathPattern(this.getTokenizedPathString(), strDirs, isCaseSensitive);
    }

    public boolean matchPatternStart(@Nonnull String str, boolean isCaseSensitive) {
        if (this.regexPattern != null) {
            return true;
        }
        String altStr = this.source.replace('\\', '/');
        return SelectorUtils.matchAntPathPatternStart(this, str, File.separator, isCaseSensitive) || SelectorUtils.matchAntPathPatternStart(this, altStr, "io/quarkus/launcher/shaded//", isCaseSensitive);
    }

    public String[] getTokenizedPathString() {
        return this.tokenized;
    }

    public boolean startsWith(String string) {
        return this.source.startsWith(string);
    }

    static String[] tokenizePathToString(@Nonnull String path, @Nonnull String separator) {
        ArrayList<String> ret = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path, separator);
        while (st.hasMoreTokens()) {
            ret.add(st.nextToken());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static MatchPattern fromString(String source) {
        return new MatchPattern(source, File.separator);
    }
}

