/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.shared.utils.logging;

import io.quarkus.launcher.shaded.org.fusesource.jansi.Ansi;
import java.util.Locale;

enum Style {
    DEBUG("io.quarkus.launcher.shaded.bold,cyan"),
    INFO("io.quarkus.launcher.shaded.bold,blue"),
    WARNING("io.quarkus.launcher.shaded.bold,yellow"),
    ERROR("io.quarkus.launcher.shaded.bold,red"),
    SUCCESS("io.quarkus.launcher.shaded.bold,green"),
    FAILURE("io.quarkus.launcher.shaded.bold,red"),
    STRONG("io.quarkus.launcher.shaded.bold"),
    MOJO("io.quarkus.launcher.shaded.green"),
    PROJECT("io.quarkus.launcher.shaded.cyan");

    private final boolean bold;
    private final boolean bright;
    private final Ansi.Color color;
    private final boolean bgBright;
    private final Ansi.Color bgColor;

    private Style(String defaultValue) {
        boolean currentBold = false;
        boolean currentBright = false;
        Ansi.Color currentColor = null;
        boolean currentBgBright = false;
        Ansi.Color currentBgColor = null;
        String value = System.getProperty("io.quarkus.launcher.shaded.style." + this.name().toLowerCase(Locale.ENGLISH), defaultValue).toLowerCase(Locale.ENGLISH);
        for (String token : value.split("io.quarkus.launcher.shaded.,")) {
            if ("io.quarkus.launcher.shaded.bold".equals(token)) {
                currentBold = true;
                continue;
            }
            if (token.startsWith("io.quarkus.launcher.shaded.bg")) {
                if ((token = token.substring(2)).startsWith("io.quarkus.launcher.shaded.bright")) {
                    currentBgBright = true;
                    token = token.substring(6);
                }
                currentBgColor = Style.toColor(token);
                continue;
            }
            if (token.startsWith("io.quarkus.launcher.shaded.bright")) {
                currentBright = true;
                token = token.substring(6);
            }
            currentColor = Style.toColor(token);
        }
        this.bold = currentBold;
        this.bright = currentBright;
        this.color = currentColor;
        this.bgBright = currentBgBright;
        this.bgColor = currentBgColor;
    }

    private static Ansi.Color toColor(String token) {
        for (Ansi.Color color : Ansi.Color.values()) {
            if (!color.toString().equalsIgnoreCase(token)) continue;
            return color;
        }
        return null;
    }

    Ansi apply(Ansi ansi) {
        if (this.bold) {
            ansi.bold();
        }
        if (this.color != null) {
            if (this.bright) {
                ansi.fgBright(this.color);
            } else {
                ansi.fg(this.color);
            }
        }
        if (this.bgColor != null) {
            if (this.bgBright) {
                ansi.bgBright(this.bgColor);
            } else {
                ansi.bg(this.bgColor);
            }
        }
        return ansi;
    }

    public String toString() {
        if (!this.bold && this.color == null && this.bgColor == null) {
            return this.name();
        }
        StringBuilder sb = new StringBuilder(this.name() + '=');
        if (this.bold) {
            sb.append("io.quarkus.launcher.shaded.bold");
        }
        if (this.color != null) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            if (this.bright) {
                sb.append("io.quarkus.launcher.shaded.bright");
            }
            sb.append(this.color.name());
        }
        if (this.bgColor != null) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append("io.quarkus.launcher.shaded.bg");
            if (this.bgBright) {
                sb.append("io.quarkus.launcher.shaded.bright");
            }
            sb.append(this.bgColor.name());
        }
        return sb.toString();
    }
}

