/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.shared.utils.xml;

import io.quarkus.launcher.shaded.org.apache.maven.shared.utils.Os;
import io.quarkus.launcher.shaded.org.apache.maven.shared.utils.xml.XMLEncode;
import io.quarkus.launcher.shaded.org.apache.maven.shared.utils.xml.XMLWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;

public class PrettyPrintXMLWriter
implements XMLWriter {
    private static final char[] CLOSE_1 = "io/quarkus/launcher/shaded//>".toCharArray();
    private static final char[] CLOSE_2 = "io/quarkus/launcher/shaded/</".toCharArray();
    private static final char[] DEFAULT_LINE_INDENT = new char[]{' ', ' '};
    private PrintWriter writer;
    private ArrayList<String> elementStack = new ArrayList();
    private boolean processingElement = false;
    private boolean documentStarted = false;
    private boolean endOnSameLine = false;
    private int depth = 0;
    private char[] lineIndent;
    private char[] lineSeparator;
    private String encoding;
    private String docType;

    public PrettyPrintXMLWriter(PrintWriter writer, String lineIndent) {
        this(writer, lineIndent, null, null);
    }

    public PrettyPrintXMLWriter(Writer writer, String lineIndent) {
        this(new PrintWriter(writer), lineIndent);
    }

    public PrettyPrintXMLWriter(PrintWriter writer) {
        this(writer, null, null);
    }

    public PrettyPrintXMLWriter(Writer writer) {
        this(new PrintWriter(writer));
    }

    public PrettyPrintXMLWriter(PrintWriter writer, String lineIndent, String encoding, String doctype) {
        this(writer, lineIndent.toCharArray(), Os.LINE_SEP.toCharArray(), encoding, doctype);
    }

    public PrettyPrintXMLWriter(Writer writer, String lineIndent, String encoding, String doctype) {
        this(new PrintWriter(writer), lineIndent, encoding, doctype);
    }

    public PrettyPrintXMLWriter(PrintWriter writer, String encoding, String doctype) {
        this(writer, DEFAULT_LINE_INDENT, Os.LINE_SEP.toCharArray(), encoding, doctype);
    }

    public PrettyPrintXMLWriter(Writer writer, String encoding, String doctype) {
        this(new PrintWriter(writer), encoding, doctype);
    }

    public PrettyPrintXMLWriter(PrintWriter writer, String lineIndent, String lineSeparator, String encoding, String doctype) {
        this(writer, lineIndent.toCharArray(), lineSeparator.toCharArray(), encoding, doctype);
    }

    private PrettyPrintXMLWriter(PrintWriter writer, char[] lineIndent, char[] lineSeparator, String encoding, String doctype) {
        this.writer = writer;
        this.lineIndent = lineIndent;
        this.lineSeparator = lineSeparator;
        this.encoding = encoding;
        this.docType = doctype;
        this.depth = 0;
        assert (!writer.checkError()) : "io.quarkus.launcher.shaded.Unexpected error state PrintWriter passed to PrettyPrintXMLWriter.";
    }

    @Override
    public void addAttribute(String key, String value) throws IOException {
        if (!this.processingElement) {
            throw new IllegalStateException("io.quarkus.launcher.shaded.currently processing no element");
        }
        this.writer.write(32);
        this.writer.write(key);
        this.writer.write(61);
        XMLEncode.xmlEncodeTextAsPCDATA(value, true, '\"', this.writer);
        if (this.writer.checkError()) {
            throw new IOException("io.quarkus.launcher.shaded.Failure adding attribute '" + key + "io.quarkus.launcher.shaded.' with value '" + value + "io.quarkus.launcher.shaded.'");
        }
    }

    @Override
    public void setEncoding(String encoding) {
        if (this.documentStarted) {
            throw new IllegalStateException("io.quarkus.launcher.shaded.Document headers already written!");
        }
        this.encoding = encoding;
    }

    @Override
    public void setDocType(String docType) {
        if (this.documentStarted) {
            throw new IllegalStateException("io.quarkus.launcher.shaded.Document headers already written!");
        }
        this.docType = docType;
    }

    public void setLineSeparator(String lineSeparator) {
        if (this.documentStarted) {
            throw new IllegalStateException("io.quarkus.launcher.shaded.Document headers already written!");
        }
        this.lineSeparator = lineSeparator.toCharArray();
    }

    public void setLineIndenter(String lineIndentParameter) {
        if (this.documentStarted) {
            throw new IllegalStateException("io.quarkus.launcher.shaded.Document headers already written!");
        }
        this.lineIndent = lineIndentParameter.toCharArray();
    }

    @Override
    public void startElement(String elementName) throws IOException {
        boolean firstLine = this.ensureDocumentStarted();
        this.completePreviouslyOpenedElement();
        if (!firstLine) {
            this.newLine();
        }
        this.writer.write(60);
        this.writer.write(elementName);
        if (this.writer.checkError()) {
            throw new IOException("io.quarkus.launcher.shaded.Failure starting element '" + elementName + "io.quarkus.launcher.shaded.'.");
        }
        this.processingElement = true;
        this.elementStack.add(this.depth++, elementName);
    }

    @Override
    public void writeText(String text) throws IOException {
        this.ensureDocumentStarted();
        this.completePreviouslyOpenedElement();
        XMLEncode.xmlEncodeText(text, this.writer);
        this.endOnSameLine = true;
        if (this.writer.checkError()) {
            throw new IOException("io.quarkus.launcher.shaded.Failure writing text.");
        }
    }

    @Override
    public void writeMarkup(String markup) throws IOException {
        this.ensureDocumentStarted();
        this.completePreviouslyOpenedElement();
        this.writer.write(markup);
        if (this.writer.checkError()) {
            throw new IOException("io.quarkus.launcher.shaded.Failure writing markup.");
        }
    }

    @Override
    public void endElement() throws IOException {
        String chars = this.elementStack.get(--this.depth);
        if (this.processingElement) {
            this.writer.write(CLOSE_1);
            this.processingElement = false;
        } else {
            if (!this.endOnSameLine) {
                this.newLine();
            }
            this.writer.write(CLOSE_2);
            this.writer.write(chars);
            this.writer.write(62);
        }
        this.endOnSameLine = false;
        if (this.writer.checkError()) {
            throw new IOException("io.quarkus.launcher.shaded.Failure ending element.");
        }
    }

    private boolean ensureDocumentStarted() {
        if (!this.documentStarted) {
            if (this.docType != null || this.encoding != null) {
                this.writeDocumentHeader();
            }
            this.documentStarted = true;
            return true;
        }
        return false;
    }

    private void writeDocumentHeader() {
        this.writer.write("io.quarkus.launcher.shaded.<?xml version=\"1.0\"");
        if (this.encoding != null) {
            this.writer.write("io.quarkus.launcher.shaded. encoding=\"");
            this.writer.write(this.encoding);
            this.writer.write(34);
        }
        this.writer.write("io.quarkus.launcher.shaded.?>");
        this.newLine();
        if (this.docType != null) {
            this.newLine();
            this.writer.write("io.quarkus.launcher.shaded.<!DOCTYPE ");
            this.writer.write(this.docType);
            this.writer.write(62);
        }
    }

    private void newLine() {
        this.writer.write(this.lineSeparator);
        for (int i = 0; i < this.depth; ++i) {
            this.writer.write(this.lineIndent);
        }
    }

    private void completePreviouslyOpenedElement() {
        if (this.processingElement) {
            this.writer.write(62);
            this.processingElement = false;
        }
    }
}

