/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.shared.utils.xml;

import io.quarkus.launcher.shaded.org.apache.maven.shared.utils.StringUtils;
import io.quarkus.launcher.shaded.org.apache.maven.shared.utils.xml.XMLWriter;
import java.io.IOException;

public class XmlWriterUtil {
    public static final String LS = System.getProperty("io.quarkus.launcher.shaded.line.separator");
    public static final int DEFAULT_INDENTATION_SIZE = 2;
    public static final int DEFAULT_COLUMN_LINE = 80;

    public static void writeLineBreak(XMLWriter writer) throws IOException {
        XmlWriterUtil.writeLineBreak(writer, 1);
    }

    public static void writeLineBreak(XMLWriter writer, int repeat) throws IOException {
        for (int i = 0; i < repeat; ++i) {
            writer.writeMarkup(LS);
        }
    }

    public static void writeLineBreak(XMLWriter writer, int repeat, int indent) throws IOException {
        XmlWriterUtil.writeLineBreak(writer, repeat, indent, 2);
    }

    public static void writeLineBreak(XMLWriter writer, int repeat, int indent, int indentSize) throws IOException {
        XmlWriterUtil.writeLineBreak(writer, repeat);
        if (indent < 0) {
            indent = 0;
        }
        if (indentSize < 0) {
            indentSize = 0;
        }
        writer.writeText(StringUtils.repeat("io.quarkus.launcher.shaded. ", indent * indentSize));
    }

    public static void writeCommentLineBreak(XMLWriter writer) throws IOException {
        XmlWriterUtil.writeCommentLineBreak(writer, 80);
    }

    public static void writeCommentLineBreak(XMLWriter writer, int columnSize) throws IOException {
        if (columnSize < 10) {
            columnSize = 80;
        }
        writer.writeMarkup("io.quarkus.launcher.shaded.<!-- " + StringUtils.repeat("io.quarkus.launcher.shaded.=", columnSize - 10) + "io.quarkus.launcher.shaded. -->" + LS);
    }

    public static void writeComment(XMLWriter writer, String comment) throws IOException {
        XmlWriterUtil.writeComment(writer, comment, 0, 2);
    }

    public static void writeComment(XMLWriter writer, String comment, int indent) throws IOException {
        XmlWriterUtil.writeComment(writer, comment, indent, 2);
    }

    public static void writeComment(XMLWriter writer, String comment, int indent, int indentSize) throws IOException {
        XmlWriterUtil.writeComment(writer, comment, indent, indentSize, 80);
    }

    public static void writeComment(XMLWriter writer, String comment, int indent, int indentSize, int columnSize) throws IOException {
        if (comment == null) {
            comment = "io.quarkus.launcher.shaded.null";
        }
        if (indent < 0) {
            indent = 0;
        }
        if (indentSize < 0) {
            indentSize = 0;
        }
        if (columnSize < 0) {
            columnSize = 80;
        }
        String indentation = StringUtils.repeat("io.quarkus.launcher.shaded. ", indent * indentSize);
        int magicNumber = indentation.length() + columnSize - "io.quarkus.launcher.shaded.-->".length() - 1;
        String[] sentences = StringUtils.split(comment, LS);
        StringBuffer line = new StringBuffer(indentation + "io.quarkus.launcher.shaded.<!-- ");
        for (String sentence : sentences) {
            String[] words;
            for (String word : words = StringUtils.split(sentence, "io.quarkus.launcher.shaded. ")) {
                StringBuilder sentenceTmp = new StringBuilder(line.toString());
                sentenceTmp.append(word).append(' ');
                if (sentenceTmp.length() > magicNumber) {
                    if (line.length() != indentation.length() + "io.quarkus.launcher.shaded.<!-- ".length()) {
                        if (magicNumber - line.length() > 0) {
                            line.append(StringUtils.repeat("io.quarkus.launcher.shaded. ", magicNumber - line.length()));
                        }
                        line.append("io.quarkus.launcher.shaded.-->").append(LS);
                        writer.writeMarkup(line.toString());
                    }
                    line = new StringBuffer(indentation + "io.quarkus.launcher.shaded.<!-- ");
                    line.append(word).append(' ');
                    continue;
                }
                line.append(word).append(' ');
            }
            if (magicNumber - line.length() <= 0) continue;
            line.append(StringUtils.repeat("io.quarkus.launcher.shaded. ", magicNumber - line.length()));
        }
        if (line.length() <= magicNumber) {
            line.append(StringUtils.repeat("io.quarkus.launcher.shaded. ", magicNumber - line.length()));
        }
        line.append("io.quarkus.launcher.shaded.-->").append(LS);
        writer.writeMarkup(line.toString());
    }

    public static void writeCommentText(XMLWriter writer, String comment) throws IOException {
        XmlWriterUtil.writeCommentText(writer, comment, 0, 2);
    }

    public static void writeCommentText(XMLWriter writer, String comment, int indent) throws IOException {
        XmlWriterUtil.writeCommentText(writer, comment, indent, 2);
    }

    public static void writeCommentText(XMLWriter writer, String comment, int indent, int indentSize) throws IOException {
        XmlWriterUtil.writeCommentText(writer, comment, indent, indentSize, 80);
    }

    public static void writeCommentText(XMLWriter writer, String comment, int indent, int indentSize, int columnSize) throws IOException {
        if (indent < 0) {
            indent = 0;
        }
        if (indentSize < 0) {
            indentSize = 0;
        }
        if (columnSize < 0) {
            columnSize = 80;
        }
        XmlWriterUtil.writeLineBreak(writer, 1);
        writer.writeMarkup(StringUtils.repeat("io.quarkus.launcher.shaded. ", indent * indentSize));
        XmlWriterUtil.writeCommentLineBreak(writer, columnSize);
        XmlWriterUtil.writeComment(writer, comment, indent, indentSize, columnSize);
        writer.writeMarkup(StringUtils.repeat("io.quarkus.launcher.shaded. ", indent * indentSize));
        XmlWriterUtil.writeCommentLineBreak(writer, columnSize);
        XmlWriterUtil.writeLineBreak(writer, 1, indent, indentSize);
    }
}

