/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.shared.utils.xml;

import io.quarkus.launcher.shaded.javax.annotation.Nonnull;
import io.quarkus.launcher.shaded.javax.annotation.WillClose;
import io.quarkus.launcher.shaded.org.apache.maven.shared.utils.io.IOUtil;
import io.quarkus.launcher.shaded.org.apache.maven.shared.utils.xml.Xpp3Dom;
import io.quarkus.launcher.shaded.org.apache.maven.shared.utils.xml.pull.XmlPullParserException;
import io.quarkus.launcher.shaded.org.xml.sax.Attributes;
import io.quarkus.launcher.shaded.org.xml.sax.ContentHandler;
import io.quarkus.launcher.shaded.org.xml.sax.InputSource;
import io.quarkus.launcher.shaded.org.xml.sax.SAXException;
import io.quarkus.launcher.shaded.org.xml.sax.SAXParseException;
import io.quarkus.launcher.shaded.org.xml.sax.XMLReader;
import io.quarkus.launcher.shaded.org.xml.sax.helpers.DefaultHandler;
import io.quarkus.launcher.shaded.org.xml.sax.helpers.XMLReaderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class Xpp3DomBuilder {
    private static final boolean DEFAULT_TRIM = true;

    public static Xpp3Dom build(@WillClose @Nonnull Reader reader) throws XmlPullParserException {
        return Xpp3DomBuilder.build(reader, true);
    }

    public static Xpp3Dom build(@WillClose InputStream is, @Nonnull String encoding) throws XmlPullParserException {
        return Xpp3DomBuilder.build(is, encoding, true);
    }

    public static Xpp3Dom build(@WillClose InputStream is, @Nonnull String encoding, boolean trim) throws XmlPullParserException {
        try {
            InputStreamReader reader = new InputStreamReader(is, encoding);
            return Xpp3DomBuilder.build(reader, trim);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Xpp3Dom build(@WillClose Reader reader, boolean trim) throws XmlPullParserException {
        try {
            DocHandler docHandler = Xpp3DomBuilder.parseSax(new InputSource(reader), trim);
            reader.close();
            reader = null;
            Xpp3Dom xpp3Dom = docHandler.result;
            return xpp3Dom;
        }
        catch (IOException e) {
            throw new XmlPullParserException(e);
        }
        finally {
            IOUtil.close(reader);
        }
    }

    private static DocHandler parseSax(@Nonnull InputSource inputSource, boolean trim) throws XmlPullParserException {
        try {
            DocHandler ch = new DocHandler(trim);
            XMLReader parser = Xpp3DomBuilder.createXmlReader();
            parser.setContentHandler((ContentHandler)ch);
            parser.parse(inputSource);
            return ch;
        }
        catch (IOException e) {
            throw new XmlPullParserException(e);
        }
        catch (SAXException e) {
            throw new XmlPullParserException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XMLReader createXmlReader() throws SAXException {
        XMLReader comSunXmlReader = Xpp3DomBuilder.instantiate("io.quarkus.launcher.shaded.com.sun.org.apache.xerces.internal.parsers.SAXParser");
        if (comSunXmlReader != null) {
            return comSunXmlReader;
        }
        String key = "io.quarkus.launcher.shaded.org.xml.sax.driver";
        String oldParser = System.getProperty(key);
        System.clearProperty(key);
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            return xMLReader;
        }
        finally {
            if (oldParser != null) {
                System.setProperty(key, oldParser);
            }
        }
    }

    private static XMLReader instantiate(String s) {
        try {
            Class<?> aClass = Thread.currentThread().getContextClassLoader().loadClass(s);
            return (XMLReader)aClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private static class DocHandler
    extends DefaultHandler {
        private final List<Xpp3Dom> elemStack = new ArrayList<Xpp3Dom>();
        private final List<StringBuilder> values = new ArrayList<StringBuilder>();
        private final List<SAXParseException> warnings = new ArrayList<SAXParseException>();
        private final List<SAXParseException> errors = new ArrayList<SAXParseException>();
        private final List<SAXParseException> fatals = new ArrayList<SAXParseException>();
        Xpp3Dom result = null;
        private final boolean trim;
        private boolean spacePreserve = false;

        DocHandler(boolean trim) {
            this.trim = trim;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.spacePreserve = false;
            Xpp3Dom child = new Xpp3Dom(localName);
            this.attachToParent(child);
            this.pushOnStack(child);
            this.values.add(new StringBuilder());
            int size = attributes.getLength();
            for (int i = 0; i < size; ++i) {
                String name = attributes.getQName(i);
                String value = attributes.getValue(i);
                child.setAttribute(name, value);
                this.spacePreserve = this.spacePreserve || "io.quarkus.launcher.shaded.xml:space".equals(name) && "io.quarkus.launcher.shaded.preserve".equals(value);
            }
        }

        private boolean pushOnStack(Xpp3Dom child) {
            return this.elemStack.add(child);
        }

        private void attachToParent(Xpp3Dom child) {
            int depth = this.elemStack.size();
            if (depth > 0) {
                this.elemStack.get(depth - 1).addChild(child);
            }
        }

        public void warning(SAXParseException e) throws SAXException {
            this.warnings.add(e);
        }

        public void error(SAXParseException e) throws SAXException {
            this.errors.add(e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            this.fatals.add(e);
        }

        private Xpp3Dom pop() {
            int depth = this.elemStack.size() - 1;
            return this.elemStack.remove(depth);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            int depth = this.elemStack.size() - 1;
            Xpp3Dom element = this.pop();
            StringBuilder accumulatedValue = this.values.remove(depth);
            if (element.getChildCount() == 0) {
                if (accumulatedValue == null) {
                    element.setValue("io.quarkus.launcher.shaded.");
                } else {
                    element.setValue(((Object)accumulatedValue).toString());
                }
            }
            if (depth == 0) {
                this.result = element;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String text = new String(ch, start, length);
            this.appendToTopValue(this.trim && !this.spacePreserve ? text.trim() : text);
        }

        private void appendToTopValue(String toAppend) {
            StringBuilder stringBuilder = this.values.get(this.values.size() - 1);
            stringBuilder.append(toAppend);
        }
    }
}

