/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.toolchain.building;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.javax.inject.Singleton;
import io.quarkus.launcher.shaded.org.apache.maven.building.Problem;
import io.quarkus.launcher.shaded.org.apache.maven.building.ProblemCollector;
import io.quarkus.launcher.shaded.org.apache.maven.building.ProblemCollectorFactory;
import io.quarkus.launcher.shaded.org.apache.maven.building.Source;
import io.quarkus.launcher.shaded.org.apache.maven.toolchain.building.DefaultToolchainsBuildingResult;
import io.quarkus.launcher.shaded.org.apache.maven.toolchain.building.ToolchainsBuilder;
import io.quarkus.launcher.shaded.org.apache.maven.toolchain.building.ToolchainsBuildingException;
import io.quarkus.launcher.shaded.org.apache.maven.toolchain.building.ToolchainsBuildingRequest;
import io.quarkus.launcher.shaded.org.apache.maven.toolchain.building.ToolchainsBuildingResult;
import io.quarkus.launcher.shaded.org.apache.maven.toolchain.io.ToolchainsParseException;
import io.quarkus.launcher.shaded.org.apache.maven.toolchain.io.ToolchainsReader;
import io.quarkus.launcher.shaded.org.apache.maven.toolchain.io.ToolchainsWriter;
import io.quarkus.launcher.shaded.org.apache.maven.toolchain.merge.MavenToolchainMerger;
import io.quarkus.launcher.shaded.org.apache.maven.toolchain.model.PersistedToolchains;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.InterpolationException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import io.quarkus.launcher.shaded.org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Named
@Singleton
public class DefaultToolchainsBuilder
implements ToolchainsBuilder {
    private MavenToolchainMerger toolchainsMerger = new MavenToolchainMerger();
    @Inject
    private ToolchainsWriter toolchainsWriter;
    @Inject
    private ToolchainsReader toolchainsReader;

    @Override
    public ToolchainsBuildingResult build(ToolchainsBuildingRequest request) throws ToolchainsBuildingException {
        ProblemCollector problems = ProblemCollectorFactory.newInstance(null);
        PersistedToolchains globalToolchains = this.readToolchains(request.getGlobalToolchainsSource(), request, problems);
        PersistedToolchains userToolchains = this.readToolchains(request.getUserToolchainsSource(), request, problems);
        this.toolchainsMerger.merge(userToolchains, globalToolchains, "io.quarkus.launcher.shaded.global-level");
        problems.setSource("io.quarkus.launcher.shaded.");
        userToolchains = this.interpolate(userToolchains, problems);
        if (this.hasErrors(problems.getProblems())) {
            throw new ToolchainsBuildingException(problems.getProblems());
        }
        return new DefaultToolchainsBuildingResult(userToolchains, problems.getProblems());
    }

    private PersistedToolchains interpolate(PersistedToolchains toolchains, ProblemCollector problems) {
        PersistedToolchains result;
        StringWriter stringWriter = new StringWriter(4096);
        try {
            this.toolchainsWriter.write(stringWriter, null, toolchains);
        }
        catch (IOException e) {
            throw new IllegalStateException("io.quarkus.launcher.shaded.Failed to serialize toolchains to memory", e);
        }
        String serializedToolchains = stringWriter.toString();
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        try {
            interpolator.addValueSource(new EnvarBasedValueSource());
        }
        catch (IOException e) {
            problems.add(Problem.Severity.WARNING, "io.quarkus.launcher.shaded.Failed to use environment variables for interpolation: " + e.getMessage(), -1, -1, e);
        }
        interpolator.addPostProcessor(new InterpolationPostProcessor(){

            @Override
            public Object execute(String expression, Object value) {
                if (value != null) {
                    value = value.toString().replace("io.quarkus.launcher.shaded.&", "io.quarkus.launcher.shaded.&amp;").replace("io.quarkus.launcher.shaded.<", "io.quarkus.launcher.shaded.&lt;").replace("io.quarkus.launcher.shaded.>", "io.quarkus.launcher.shaded.&gt;");
                    return value;
                }
                return null;
            }
        });
        try {
            serializedToolchains = interpolator.interpolate(serializedToolchains);
        }
        catch (InterpolationException e) {
            problems.add(Problem.Severity.ERROR, "io.quarkus.launcher.shaded.Failed to interpolate toolchains: " + e.getMessage(), -1, -1, e);
            return toolchains;
        }
        try {
            Map<String, Boolean> options = Collections.singletonMap("io.quarkus.launcher.shaded.org.apache.maven.toolchains.io.isStrict", Boolean.FALSE);
            result = this.toolchainsReader.read(new StringReader(serializedToolchains), options);
        }
        catch (IOException e) {
            problems.add(Problem.Severity.ERROR, "io.quarkus.launcher.shaded.Failed to interpolate toolchains: " + e.getMessage(), -1, -1, e);
            return toolchains;
        }
        return result;
    }

    private PersistedToolchains readToolchains(Source toolchainsSource, ToolchainsBuildingRequest request, ProblemCollector problems) {
        PersistedToolchains toolchains;
        if (toolchainsSource == null) {
            return new PersistedToolchains();
        }
        try {
            Map<String, Boolean> options = Collections.singletonMap("io.quarkus.launcher.shaded.org.apache.maven.toolchains.io.isStrict", Boolean.TRUE);
            try {
                toolchains = this.toolchainsReader.read(toolchainsSource.getInputStream(), options);
            }
            catch (ToolchainsParseException e) {
                options = Collections.singletonMap("io.quarkus.launcher.shaded.org.apache.maven.toolchains.io.isStrict", Boolean.FALSE);
                toolchains = this.toolchainsReader.read(toolchainsSource.getInputStream(), options);
                problems.add(Problem.Severity.WARNING, e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
            }
        }
        catch (ToolchainsParseException e) {
            problems.add(Problem.Severity.FATAL, "io.quarkus.launcher.shaded.Non-parseable toolchains " + toolchainsSource.getLocation() + "io.quarkus.launcher.shaded.: " + e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
            return new PersistedToolchains();
        }
        catch (IOException e) {
            problems.add(Problem.Severity.FATAL, "io.quarkus.launcher.shaded.Non-readable toolchains " + toolchainsSource.getLocation() + "io.quarkus.launcher.shaded.: " + e.getMessage(), -1, -1, e);
            return new PersistedToolchains();
        }
        return toolchains;
    }

    private boolean hasErrors(List<Problem> problems) {
        if (problems != null) {
            for (Problem problem : problems) {
                if (Problem.Severity.ERROR.compareTo(problem.getSeverity()) < 0) continue;
                return true;
            }
        }
        return false;
    }
}

