/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.toolchain.building;

import io.quarkus.launcher.shaded.org.apache.maven.building.Problem;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class ToolchainsBuildingException
extends Exception {
    private final List<Problem> problems = new ArrayList<Problem>();

    public ToolchainsBuildingException(List<Problem> problems) {
        super(ToolchainsBuildingException.toMessage(problems));
        if (problems != null) {
            this.problems.addAll(problems);
        }
    }

    public List<Problem> getProblems() {
        return this.problems;
    }

    private static String toMessage(List<Problem> problems) {
        StringWriter buffer = new StringWriter(1024);
        PrintWriter writer = new PrintWriter(buffer);
        writer.print(problems.size());
        writer.print(problems.size() == 1 ? "io.quarkus.launcher.shaded. problem was " : "io.quarkus.launcher.shaded. problems were ");
        writer.print("io.quarkus.launcher.shaded.encountered while building the effective toolchains");
        writer.println();
        for (Problem problem : problems) {
            writer.print("io.quarkus.launcher.shaded.[");
            writer.print((Object)problem.getSeverity());
            writer.print("io.quarkus.launcher.shaded.] ");
            writer.print(problem.getMessage());
            String location = problem.getLocation();
            if (!location.isEmpty()) {
                writer.print("io.quarkus.launcher.shaded. @ ");
                writer.print(location);
            }
            writer.println();
        }
        return buffer.toString();
    }
}

