/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.toolchain.io;

import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.javax.inject.Singleton;
import io.quarkus.launcher.shaded.org.apache.maven.toolchain.io.ToolchainsParseException;
import io.quarkus.launcher.shaded.org.apache.maven.toolchain.io.ToolchainsReader;
import io.quarkus.launcher.shaded.org.apache.maven.toolchain.model.PersistedToolchains;
import io.quarkus.launcher.shaded.org.apache.maven.toolchain.model.io.xpp3.MavenToolchainsXpp3Reader;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.ReaderFactory;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.Objects;

@Named
@Singleton
public class DefaultToolchainsReader
implements ToolchainsReader {
    @Override
    public PersistedToolchains read(File input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "io.quarkus.launcher.shaded.input cannot be null");
        return this.read(ReaderFactory.newXmlReader(input), options);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PersistedToolchains read(Reader input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "io.quarkus.launcher.shaded.input cannot be null");
        try (Reader in = input;){
            PersistedToolchains persistedToolchains = new MavenToolchainsXpp3Reader().read(in, this.isStrict(options));
            return persistedToolchains;
        }
        catch (XmlPullParserException e) {
            throw new ToolchainsParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PersistedToolchains read(InputStream input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "io.quarkus.launcher.shaded.input cannot be null");
        try (InputStream in = input;){
            PersistedToolchains persistedToolchains = new MavenToolchainsXpp3Reader().read(in, this.isStrict(options));
            return persistedToolchains;
        }
        catch (XmlPullParserException e) {
            throw new ToolchainsParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
        }
    }

    private boolean isStrict(Map<String, ?> options) {
        Object value = options != null ? (Object)options.get("io.quarkus.launcher.shaded.org.apache.maven.toolchains.io.isStrict") : null;
        return value == null || Boolean.parseBoolean(value.toString());
    }
}

