/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.toolchain.java;

import io.quarkus.launcher.shaded.org.apache.maven.toolchain.DefaultToolchain;
import io.quarkus.launcher.shaded.org.apache.maven.toolchain.java.JavaToolchain;
import io.quarkus.launcher.shaded.org.apache.maven.toolchain.model.ToolchainModel;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.Logger;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.FileUtils;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.Os;
import java.io.File;

class JavaToolchainImpl
extends DefaultToolchain
implements JavaToolchain {
    private String javaHome;
    public static final String KEY_JAVAHOME = "io.quarkus.launcher.shaded.jdkHome";

    JavaToolchainImpl(ToolchainModel model, Logger logger) {
        super(model, "io.quarkus.launcher.shaded.jdk", logger);
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    @Override
    public String toString() {
        return "io.quarkus.launcher.shaded.JDK[" + this.getJavaHome() + "io.quarkus.launcher.shaded.]";
    }

    @Override
    public String findTool(String toolName) {
        File toRet = JavaToolchainImpl.findTool(toolName, new File(FileUtils.normalize(this.getJavaHome())));
        if (toRet != null) {
            return toRet.getAbsolutePath();
        }
        return null;
    }

    private static File findTool(String toolName, File installFolder) {
        File tool;
        File bin = new File(installFolder, "io.quarkus.launcher.shaded.bin");
        if (bin.exists() && (tool = new File(bin, toolName + (Os.isFamily("io.quarkus.launcher.shaded.windows") ? "io.quarkus.launcher.shaded..exe" : "io.quarkus.launcher.shaded."))).exists()) {
            return tool;
        }
        return null;
    }
}

