/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.wagon;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public class LazyFileOutputStream
extends OutputStream {
    private File file;
    private FileOutputStream delegee;

    public LazyFileOutputStream(String filename) {
        this.file = new File(filename);
    }

    public LazyFileOutputStream(File file) {
        this.file = file;
    }

    @Override
    public void close() throws IOException {
        if (this.delegee != null) {
            this.delegee.close();
        }
    }

    public boolean equals(Object obj) {
        return this.delegee.equals(obj);
    }

    @Override
    public void flush() throws IOException {
        if (this.delegee != null) {
            this.delegee.flush();
        }
    }

    public FileChannel getChannel() {
        return this.delegee.getChannel();
    }

    public FileDescriptor getFD() throws IOException {
        return this.delegee.getFD();
    }

    public int hashCode() {
        return this.delegee.hashCode();
    }

    public String toString() {
        return this.delegee.toString();
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.delegee == null) {
            this.initialize();
        }
        this.delegee.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.delegee == null) {
            this.initialize();
        }
        this.delegee.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.delegee == null) {
            this.initialize();
        }
        this.delegee.write(b);
    }

    private void initialize() throws FileNotFoundException {
        this.delegee = new FileOutputStream(this.file);
    }
}

