/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.wagon;

import io.quarkus.launcher.shaded.org.apache.maven.wagon.AbstractWagon;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.ConnectionException;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.InputData;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.OutputData;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.ResourceDoesNotExistException;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.StreamingWagon;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.TransferFailedException;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.authorization.AuthorizationException;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.resource.Resource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class StreamWagon
extends AbstractWagon
implements StreamingWagon {
    public abstract void fillInputData(InputData var1) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException;

    public abstract void fillOutputData(OutputData var1) throws TransferFailedException;

    @Override
    public abstract void closeConnection() throws ConnectionException;

    @Override
    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.getIfNewer(resourceName, destination, 0L);
    }

    protected void checkInputStream(InputStream is, Resource resource) throws TransferFailedException {
        if (is == null) {
            TransferFailedException e = new TransferFailedException(this.getRepository().getUrl() + "io.quarkus.launcher.shaded. - Could not open input stream for resource: '" + resource + "io.quarkus.launcher.shaded.'");
            this.fireTransferError(resource, e, 5);
            throw e;
        }
    }

    @Override
    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        boolean retValue = false;
        Resource resource = new Resource(resourceName);
        this.fireGetInitiated(resource, destination);
        resource.setLastModified(timestamp);
        InputStream is = this.getInputStream(resource);
        if (timestamp == 0L || timestamp < resource.getLastModified()) {
            retValue = true;
            this.checkInputStream(is, resource);
            this.getTransfer(resource, destination, is);
        } else {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new TransferFailedException("io.quarkus.launcher.shaded.Failure transferring " + resourceName, e);
            }
        }
        return retValue;
    }

    protected InputStream getInputStream(Resource resource) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        InputData inputData = new InputData();
        inputData.setResource(resource);
        try {
            this.fillInputData(inputData);
        }
        catch (TransferFailedException e) {
            this.fireTransferError(resource, e, 5);
            this.cleanupGetTransfer(resource);
            throw e;
        }
        catch (ResourceDoesNotExistException e) {
            this.fireTransferError(resource, e, 5);
            this.cleanupGetTransfer(resource);
            throw e;
        }
        catch (AuthorizationException e) {
            this.fireTransferError(resource, e, 5);
            this.cleanupGetTransfer(resource);
            throw e;
        }
        finally {
            if (inputData.getInputStream() == null) {
                this.cleanupGetTransfer(resource);
            }
        }
        return inputData.getInputStream();
    }

    @Override
    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.firePutInitiated(resource, source);
        resource.setContentLength(source.length());
        resource.setLastModified(source.lastModified());
        OutputStream os = this.getOutputStream(resource);
        this.checkOutputStream(resource, os);
        this.putTransfer(resource, source, os, true);
    }

    protected void checkOutputStream(Resource resource, OutputStream os) throws TransferFailedException {
        if (os == null) {
            TransferFailedException e = new TransferFailedException(this.getRepository().getUrl() + "io.quarkus.launcher.shaded. - Could not open output stream for resource: '" + resource + "io.quarkus.launcher.shaded.'");
            this.fireTransferError(resource, e, 6);
            throw e;
        }
    }

    protected OutputStream getOutputStream(Resource resource) throws TransferFailedException {
        OutputData outputData = new OutputData();
        outputData.setResource(resource);
        try {
            this.fillOutputData(outputData);
        }
        catch (TransferFailedException e) {
            this.fireTransferError(resource, e, 6);
            throw e;
        }
        finally {
            if (outputData.getOutputStream() == null) {
                this.cleanupPutTransfer(resource);
            }
        }
        return outputData.getOutputStream();
    }

    @Override
    public boolean getIfNewerToStream(String resourceName, OutputStream stream, long timestamp) throws ResourceDoesNotExistException, TransferFailedException, AuthorizationException {
        boolean retValue = false;
        Resource resource = new Resource(resourceName);
        this.fireGetInitiated(resource, null);
        InputStream is = this.getInputStream(resource);
        if (timestamp == 0L || timestamp < resource.getLastModified()) {
            retValue = true;
            this.checkInputStream(is, resource);
            this.fireGetStarted(resource, null);
            this.getTransfer(resource, stream, is, true, Integer.MAX_VALUE);
            this.fireGetCompleted(resource, null);
        } else {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new TransferFailedException("io.quarkus.launcher.shaded.Failure transferring " + resourceName, e);
            }
        }
        return retValue;
    }

    @Override
    public void getToStream(String resourceName, OutputStream stream) throws ResourceDoesNotExistException, TransferFailedException, AuthorizationException {
        this.getIfNewerToStream(resourceName, stream, 0L);
    }

    @Override
    public void putFromStream(InputStream stream, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(destination);
        this.firePutInitiated(resource, null);
        this.putFromStream(stream, resource);
    }

    @Override
    public void putFromStream(InputStream stream, String destination, long contentLength, long lastModified) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(destination);
        this.firePutInitiated(resource, null);
        resource.setContentLength(contentLength);
        resource.setLastModified(lastModified);
        this.putFromStream(stream, resource);
    }

    protected void putFromStream(InputStream stream, Resource resource) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        OutputStream os = this.getOutputStream(resource);
        this.checkOutputStream(resource, os);
        this.firePutStarted(resource, null);
        this.putTransfer(resource, stream, os, true);
        this.firePutCompleted(resource, null);
    }
}

