/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.wagon;

import io.quarkus.launcher.shaded.org.apache.maven.wagon.ResourceDoesNotExistException;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.TransferFailedException;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.Wagon;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.authorization.AuthorizationException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;

public final class WagonUtils {
    private WagonUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String resource, Wagon wagon) throws IOException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        File file = null;
        try {
            file = File.createTempFile("io.quarkus.launcher.shaded.wagon", "io.quarkus.launcher.shaded.tmp");
            wagon.get(resource, file);
            String string = FileUtils.fileRead(file);
            return string;
        }
        finally {
            boolean deleted;
            if (file != null && !(deleted = file.delete())) {
                file.deleteOnExit();
            }
        }
    }

    public static void putDirectory(File dir, Wagon wagon, boolean includeBasdir) throws ResourceDoesNotExistException, TransferFailedException, AuthorizationException {
        LinkedList<String> queue = new LinkedList<String>();
        if (includeBasdir) {
            queue.add(dir.getName());
        } else {
            queue.add("io.quarkus.launcher.shaded.");
        }
        while (!queue.isEmpty()) {
            String path = (String)queue.removeFirst();
            File currentDir = new File(dir, path);
            File[] files = currentDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String resource = path.length() > 0 ? path + "io/quarkus/launcher/shaded//" + file.getName() : file.getName();
                if (file.isDirectory()) {
                    queue.add(resource);
                    continue;
                }
                wagon.put(file, resource);
            }
        }
    }
}

