/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.wagon.observers;

import io.quarkus.launcher.shaded.org.apache.maven.wagon.events.TransferEvent;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.events.TransferListener;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ChecksumObserver
implements TransferListener {
    private MessageDigest digester = null;
    private String actualChecksum;

    public ChecksumObserver() throws NoSuchAlgorithmException {
        this("io.quarkus.launcher.shaded.MD5");
    }

    public ChecksumObserver(String algorithm) throws NoSuchAlgorithmException {
        this.digester = MessageDigest.getInstance(algorithm);
    }

    @Override
    public void transferInitiated(TransferEvent transferEvent) {
    }

    @Override
    public void transferStarted(TransferEvent transferEvent) {
        this.actualChecksum = null;
        this.digester.reset();
    }

    @Override
    public void transferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
        this.digester.update(buffer, 0, length);
    }

    @Override
    public void transferCompleted(TransferEvent transferEvent) {
        this.actualChecksum = this.encode(this.digester.digest());
    }

    @Override
    public void transferError(TransferEvent transferEvent) {
        this.digester.reset();
        this.actualChecksum = null;
    }

    @Override
    public void debug(String message) {
    }

    public String getActualChecksum() {
        return this.actualChecksum;
    }

    protected String encode(byte[] binaryData) {
        if (binaryData.length != 16 && binaryData.length != 20) {
            int bitLength = binaryData.length * 8;
            throw new IllegalArgumentException("io.quarkus.launcher.shaded.Unrecognised length for binary data: " + bitLength + "io.quarkus.launcher.shaded. bits");
        }
        StringBuilder retValue = new StringBuilder();
        for (byte b : binaryData) {
            String t = Integer.toHexString(b & 0xFF);
            if (t.length() == 1) {
                retValue.append('0').append(t);
                continue;
            }
            retValue.append(t);
        }
        return retValue.toString().trim();
    }
}

