/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.wagon.observers;

import io.quarkus.launcher.shaded.org.apache.maven.wagon.events.SessionEvent;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.events.SessionListener;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.events.TransferEvent;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.events.TransferListener;
import java.io.PrintStream;

public class Debug
implements SessionListener,
TransferListener {
    private PrintStream out;
    long timestamp;
    long transfer;

    public Debug() {
        this(System.out);
    }

    public Debug(PrintStream out) {
        this.out = out;
    }

    @Override
    public void sessionOpening(SessionEvent sessionEvent) {
    }

    @Override
    public void sessionOpened(SessionEvent sessionEvent) {
        this.out.println(sessionEvent.getWagon().getRepository().getUrl() + "io.quarkus.launcher.shaded. - Session: Opened  ");
    }

    @Override
    public void sessionDisconnecting(SessionEvent sessionEvent) {
        this.out.println(sessionEvent.getWagon().getRepository().getUrl() + "io.quarkus.launcher.shaded. - Session: Disconnecting  ");
    }

    @Override
    public void sessionDisconnected(SessionEvent sessionEvent) {
        this.out.println(sessionEvent.getWagon().getRepository().getUrl() + "io.quarkus.launcher.shaded. - Session: Disconnected");
    }

    @Override
    public void sessionConnectionRefused(SessionEvent sessionEvent) {
        this.out.println(sessionEvent.getWagon().getRepository().getUrl() + "io.quarkus.launcher.shaded. - Session: Connection refused");
    }

    @Override
    public void sessionLoggedIn(SessionEvent sessionEvent) {
        this.out.println(sessionEvent.getWagon().getRepository().getUrl() + "io.quarkus.launcher.shaded. - Session: Logged in");
    }

    @Override
    public void sessionLoggedOff(SessionEvent sessionEvent) {
        this.out.println(sessionEvent.getWagon().getRepository().getUrl() + "io.quarkus.launcher.shaded. - Session: Logged off");
    }

    @Override
    public void debug(String message) {
        this.out.println(message);
    }

    @Override
    public void transferInitiated(TransferEvent transferEvent) {
    }

    @Override
    public void transferStarted(TransferEvent transferEvent) {
        this.timestamp = transferEvent.getTimestamp();
        this.transfer = 0L;
        if (transferEvent.getRequestType() == 5) {
            String message = "io.quarkus.launcher.shaded.Downloading: " + transferEvent.getResource().getName() + "io.quarkus.launcher.shaded. from " + transferEvent.getWagon().getRepository().getUrl();
            this.out.println(message);
            this.out.println("io.quarkus.launcher.shaded.");
        } else {
            String message = "io.quarkus.launcher.shaded.Uploading: " + transferEvent.getResource().getName() + "io.quarkus.launcher.shaded. to " + transferEvent.getWagon().getRepository().getUrl();
            this.out.println(message);
            this.out.println("io.quarkus.launcher.shaded.");
        }
    }

    @Override
    public void transferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
        this.out.print("io.quarkus.launcher.shaded.#");
        this.transfer += (long)length;
    }

    @Override
    public void transferCompleted(TransferEvent transferEvent) {
        double duration = (double)(transferEvent.getTimestamp() - this.timestamp) / 1000.0;
        this.out.println();
        String message = "io.quarkus.launcher.shaded.Transfer finished. " + this.transfer + "io.quarkus.launcher.shaded. bytes copied in " + duration + "io.quarkus.launcher.shaded. seconds";
        this.out.println(message);
    }

    @Override
    public void transferError(TransferEvent transferEvent) {
        this.out.println("io.quarkus.launcher.shaded. Transfer error: " + transferEvent.getException());
    }

    @Override
    public void sessionError(SessionEvent sessionEvent) {
        this.out.println("io.quarkus.launcher.shaded. Session error: " + sessionEvent.getException());
    }

    public PrintStream getOut() {
        return this.out;
    }
}

