/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.wagon.providers.file;

import io.quarkus.launcher.shaded.org.apache.maven.wagon.ConnectionException;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.InputData;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.LazyFileOutputStream;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.OutputData;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.ResourceDoesNotExistException;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.StreamWagon;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.TransferFailedException;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.authorization.AuthorizationException;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.resource.Resource;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FileWagon
extends StreamWagon {
    @Override
    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException {
        if (this.getRepository().getBasedir() == null) {
            throw new TransferFailedException("io.quarkus.launcher.shaded.Unable to operate with a null basedir.");
        }
        Resource resource = inputData.getResource();
        File file = new File(this.getRepository().getBasedir(), resource.getName());
        if (!file.exists()) {
            throw new ResourceDoesNotExistException("io.quarkus.launcher.shaded.File: " + file + "io.quarkus.launcher.shaded. does not exist");
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            inputData.setInputStream(in);
            resource.setContentLength(file.length());
            resource.setLastModified(file.lastModified());
        }
        catch (FileNotFoundException e) {
            throw new TransferFailedException("io.quarkus.launcher.shaded.Could not read from file: " + file.getAbsolutePath(), e);
        }
    }

    @Override
    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        if (this.getRepository().getBasedir() == null) {
            throw new TransferFailedException("io.quarkus.launcher.shaded.Unable to operate with a null basedir.");
        }
        Resource resource = outputData.getResource();
        File file = new File(this.getRepository().getBasedir(), resource.getName());
        this.createParentDirectories(file);
        BufferedOutputStream outputStream = new BufferedOutputStream(new LazyFileOutputStream(file));
        outputData.setOutputStream(outputStream);
    }

    @Override
    protected void openConnectionInternal() throws ConnectionException {
        if (this.getRepository() == null) {
            throw new ConnectionException("io.quarkus.launcher.shaded.Unable to operate with a null repository.");
        }
        if (this.getRepository().getBasedir() == null) {
            this.fireSessionDebug("io.quarkus.launcher.shaded.Using a null basedir.");
            return;
        }
        File basedir = new File(this.getRepository().getBasedir());
        if (!basedir.exists() && !basedir.mkdirs()) {
            throw new ConnectionException("io.quarkus.launcher.shaded.Repository path " + basedir + "io.quarkus.launcher.shaded. does not exist," + "io.quarkus.launcher.shaded. and cannot be created.");
        }
        if (!basedir.canRead()) {
            throw new ConnectionException("io.quarkus.launcher.shaded.Repository path " + basedir + "io.quarkus.launcher.shaded. cannot be read");
        }
    }

    @Override
    public void closeConnection() {
    }

    @Override
    public boolean supportsDirectoryCopy() {
        return true;
    }

    @Override
    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (this.getRepository().getBasedir() == null) {
            throw new TransferFailedException("io.quarkus.launcher.shaded.Unable to putDirectory() with a null basedir.");
        }
        File path = this.resolveDestinationPath(destinationDirectory);
        try {
            File realFile = path.getCanonicalFile();
            realFile.mkdirs();
        }
        catch (IOException e) {
            path.mkdirs();
        }
        if (!path.exists() || !path.isDirectory()) {
            String emsg = "io.quarkus.launcher.shaded.Could not make directory '" + path.getAbsolutePath() + "io.quarkus.launcher.shaded.'.";
            File basedir = new File(this.getRepository().getBasedir());
            if (!basedir.canWrite()) {
                emsg = emsg + "io.quarkus.launcher.shaded.  The base directory " + basedir + "io.quarkus.launcher.shaded. is read-only.";
            }
            throw new TransferFailedException(emsg);
        }
        try {
            FileUtils.copyDirectoryStructure(sourceDirectory, path);
        }
        catch (IOException e) {
            throw new TransferFailedException("io.quarkus.launcher.shaded.Error copying directory structure", e);
        }
    }

    private File resolveDestinationPath(String destinationPath) {
        String basedir = this.getRepository().getBasedir();
        File path = (destinationPath = destinationPath.replace("io.quarkus.launcher.shaded.\\", "io/quarkus/launcher/shaded//")).equals("io.quarkus.launcher.shaded..") ? new File(basedir) : new File(basedir, destinationPath);
        return path;
    }

    @Override
    public List<String> getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (this.getRepository().getBasedir() == null) {
            throw new TransferFailedException("io.quarkus.launcher.shaded.Unable to getFileList() with a null basedir.");
        }
        File path = this.resolveDestinationPath(destinationDirectory);
        if (!path.exists()) {
            throw new ResourceDoesNotExistException("io.quarkus.launcher.shaded.Directory does not exist: " + destinationDirectory);
        }
        if (!path.isDirectory()) {
            throw new ResourceDoesNotExistException("io.quarkus.launcher.shaded.Path is not a directory: " + destinationDirectory);
        }
        File[] files = path.listFiles();
        ArrayList<String> list = new ArrayList<String>(files.length);
        for (File file : files) {
            String name = file.getName();
            if (file.isDirectory() && !name.endsWith("io/quarkus/launcher/shaded//")) {
                name = name + "io/quarkus/launcher/shaded//";
            }
            list.add(name);
        }
        return list;
    }

    @Override
    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        if (this.getRepository().getBasedir() == null) {
            throw new TransferFailedException("io.quarkus.launcher.shaded.Unable to getFileList() with a null basedir.");
        }
        File file = this.resolveDestinationPath(resourceName);
        if (resourceName.endsWith("io/quarkus/launcher/shaded//")) {
            return file.isDirectory();
        }
        return file.exists();
    }
}

