/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.wagon.providers.http;

import io.quarkus.launcher.shaded.org.apache.http.HttpEntity;
import io.quarkus.launcher.shaded.org.apache.http.HttpException;
import io.quarkus.launcher.shaded.org.apache.http.client.methods.CloseableHttpResponse;
import io.quarkus.launcher.shaded.org.apache.http.client.methods.HttpGet;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.ResourceDoesNotExistException;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.TransferFailedException;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.authorization.AuthorizationException;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.shared.http.AbstractHttpClientWagon;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.shared.http.HtmlFileListParser;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.shared.http.HttpMessageUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class HttpWagon
extends AbstractHttpClientWagon {
    @Override
    public List<String> getFileList(String destinationDirectory) throws AuthorizationException, ResourceDoesNotExistException, TransferFailedException {
        return this.getFileList(this.getInitialBackoffSeconds(), destinationDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getFileList(int wait, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (destinationDirectory.length() > 0 && !destinationDirectory.endsWith("io/quarkus/launcher/shaded//")) {
            destinationDirectory = destinationDirectory + "io/quarkus/launcher/shaded//";
        }
        String url = this.getRepository().getUrl() + "io/quarkus/launcher/shaded//" + destinationDirectory;
        HttpGet getMethod = new HttpGet(url);
        try (CloseableHttpResponse response = this.execute(getMethod);){
            String reasonPhrase = response.getStatusLine().getReasonPhrase();
            int statusCode = response.getStatusLine().getStatusCode();
            this.fireTransferDebug(HttpMessageUtils.formatTransferDebugMessage(url, statusCode, reasonPhrase, this.getProxyInfo()));
            switch (statusCode) {
                case 200: {
                    break;
                }
                case 401: 
                case 403: 
                case 407: {
                    throw new AuthorizationException(HttpMessageUtils.formatAuthorizationMessage(url, statusCode, reasonPhrase, this.getProxyInfo()));
                }
                case 404: {
                    throw new ResourceDoesNotExistException(HttpMessageUtils.formatResourceDoesNotExistMessage(url, statusCode, reasonPhrase, this.getProxyInfo()));
                }
                case 429: {
                    List<String> list = this.getFileList(this.backoff(wait, url), destinationDirectory);
                    return list;
                }
                default: {
                    throw new TransferFailedException(HttpMessageUtils.formatTransferFailedMessage(url, statusCode, reasonPhrase, this.getProxyInfo()));
                }
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                List<String> list = HtmlFileListParser.parseFileList(url, entity.getContent());
                return list;
            }
            List<String> list = Collections.emptyList();
            return list;
        }
        catch (IOException e) {
            throw new TransferFailedException("io.quarkus.launcher.shaded.Could not read response body.", e);
        }
        catch (HttpException e) {
            throw new TransferFailedException("io.quarkus.launcher.shaded.Could not read response body.", e);
        }
        catch (InterruptedException e) {
            throw new TransferFailedException("io.quarkus.launcher.shaded.Unable to wait for resource.", e);
        }
    }
}

