/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.wagon.shared.http;

import io.quarkus.launcher.shaded.javax.net.ssl.HttpsURLConnection;
import io.quarkus.launcher.shaded.javax.net.ssl.SSLContext;
import io.quarkus.launcher.shaded.org.apache.http.Header;
import io.quarkus.launcher.shaded.org.apache.http.HttpEntity;
import io.quarkus.launcher.shaded.org.apache.http.HttpException;
import io.quarkus.launcher.shaded.org.apache.http.HttpHost;
import io.quarkus.launcher.shaded.org.apache.http.HttpResponse;
import io.quarkus.launcher.shaded.org.apache.http.auth.AuthSchemeProvider;
import io.quarkus.launcher.shaded.org.apache.http.auth.AuthScope;
import io.quarkus.launcher.shaded.org.apache.http.auth.ChallengeState;
import io.quarkus.launcher.shaded.org.apache.http.auth.Credentials;
import io.quarkus.launcher.shaded.org.apache.http.auth.NTCredentials;
import io.quarkus.launcher.shaded.org.apache.http.auth.UsernamePasswordCredentials;
import io.quarkus.launcher.shaded.org.apache.http.client.AuthCache;
import io.quarkus.launcher.shaded.org.apache.http.client.CredentialsProvider;
import io.quarkus.launcher.shaded.org.apache.http.client.HttpRequestRetryHandler;
import io.quarkus.launcher.shaded.org.apache.http.client.ServiceUnavailableRetryStrategy;
import io.quarkus.launcher.shaded.org.apache.http.client.config.RequestConfig;
import io.quarkus.launcher.shaded.org.apache.http.client.methods.CloseableHttpResponse;
import io.quarkus.launcher.shaded.org.apache.http.client.methods.HttpGet;
import io.quarkus.launcher.shaded.org.apache.http.client.methods.HttpHead;
import io.quarkus.launcher.shaded.org.apache.http.client.methods.HttpPut;
import io.quarkus.launcher.shaded.org.apache.http.client.methods.HttpUriRequest;
import io.quarkus.launcher.shaded.org.apache.http.client.protocol.HttpClientContext;
import io.quarkus.launcher.shaded.org.apache.http.client.utils.DateUtils;
import io.quarkus.launcher.shaded.org.apache.http.config.Registry;
import io.quarkus.launcher.shaded.org.apache.http.config.RegistryBuilder;
import io.quarkus.launcher.shaded.org.apache.http.conn.HttpClientConnectionManager;
import io.quarkus.launcher.shaded.org.apache.http.conn.socket.ConnectionSocketFactory;
import io.quarkus.launcher.shaded.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import io.quarkus.launcher.shaded.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import io.quarkus.launcher.shaded.org.apache.http.conn.ssl.SSLContextBuilder;
import io.quarkus.launcher.shaded.org.apache.http.conn.ssl.SSLInitializationException;
import io.quarkus.launcher.shaded.org.apache.http.entity.AbstractHttpEntity;
import io.quarkus.launcher.shaded.org.apache.http.impl.auth.BasicScheme;
import io.quarkus.launcher.shaded.org.apache.http.impl.auth.BasicSchemeFactory;
import io.quarkus.launcher.shaded.org.apache.http.impl.auth.DigestSchemeFactory;
import io.quarkus.launcher.shaded.org.apache.http.impl.auth.NTLMSchemeFactory;
import io.quarkus.launcher.shaded.org.apache.http.impl.client.BasicAuthCache;
import io.quarkus.launcher.shaded.org.apache.http.impl.client.BasicCredentialsProvider;
import io.quarkus.launcher.shaded.org.apache.http.impl.client.CloseableHttpClient;
import io.quarkus.launcher.shaded.org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.client.DefaultServiceUnavailableRetryStrategy;
import io.quarkus.launcher.shaded.org.apache.http.impl.client.HttpClientBuilder;
import io.quarkus.launcher.shaded.org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import io.quarkus.launcher.shaded.org.apache.http.message.BasicHeader;
import io.quarkus.launcher.shaded.org.apache.http.util.EntityUtils;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.InputData;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.OutputData;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.PathUtils;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.ResourceDoesNotExistException;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.StreamWagon;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.TransferFailedException;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.Wagon;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.authorization.AuthorizationException;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.events.TransferEvent;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.proxy.ProxyInfo;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.repository.Repository;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.resource.Resource;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.shared.http.BasicAuthScope;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.shared.http.ConfigurationUtils;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.shared.http.EncodingUtil;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.shared.http.HttpConfiguration;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.shared.http.HttpMessageUtils;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.shared.http.HttpMethodConfiguration;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.shared.http.RelaxedTrustStrategy;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.shared.http.StandardServiceUnavailableRetryStrategy;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public abstract class AbstractHttpClientWagon
extends StreamWagon {
    private static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("io.quarkus.launcher.shaded.GMT");
    private static boolean persistentPool = Boolean.valueOf(System.getProperty("io.quarkus.launcher.shaded.maven.wagon.http.pool", "io.quarkus.launcher.shaded.true"));
    private static final boolean SSL_INSECURE = Boolean.valueOf(System.getProperty("io.quarkus.launcher.shaded.maven.wagon.http.ssl.insecure", "io.quarkus.launcher.shaded.false"));
    private static final boolean IGNORE_SSL_VALIDITY_DATES = Boolean.valueOf(System.getProperty("io.quarkus.launcher.shaded.maven.wagon.http.ssl.ignore.validity.dates", "io.quarkus.launcher.shaded.false"));
    private static final boolean SSL_ALLOW_ALL = Boolean.valueOf(System.getProperty("io.quarkus.launcher.shaded.maven.wagon.http.ssl.allowall", "io.quarkus.launcher.shaded.false"));
    private static final int MAX_CONN_PER_ROUTE = Integer.parseInt(System.getProperty("io.quarkus.launcher.shaded.maven.wagon.httpconnectionManager.maxPerRoute", "io.quarkus.launcher.shaded.20"));
    private static final int MAX_CONN_TOTAL = Integer.parseInt(System.getProperty("io.quarkus.launcher.shaded.maven.wagon.httpconnectionManager.maxTotal", "io.quarkus.launcher.shaded.40"));
    private static final long CONN_TTL = Long.getLong("io.quarkus.launcher.shaded.maven.wagon.httpconnectionManager.ttlSeconds", 300L);
    private static HttpClientConnectionManager httpClientConnectionManager = AbstractHttpClientWagon.createConnManager();
    protected static final int SC_TOO_MANY_REQUESTS = 429;
    private int initialBackoffSeconds = Integer.parseInt(System.getProperty("io.quarkus.launcher.shaded.maven.wagon.httpconnectionManager.backoffSeconds", "io.quarkus.launcher.shaded.5"));
    private static final int MAX_BACKOFF_WAIT_SECONDS = Integer.parseInt(System.getProperty("io.quarkus.launcher.shaded.maven.wagon.httpconnectionManager.maxBackoffSeconds", "io.quarkus.launcher.shaded.180"));
    private static final String RETRY_HANDLER_CLASS = System.getProperty("io.quarkus.launcher.shaded.maven.wagon.http.retryHandler.class", "io.quarkus.launcher.shaded.standard");
    private static final boolean RETRY_HANDLER_REQUEST_SENT_ENABLED = Boolean.getBoolean("io.quarkus.launcher.shaded.maven.wagon.http.retryHandler.requestSentEnabled");
    private static final int RETRY_HANDLER_COUNT = Integer.getInteger("io.quarkus.launcher.shaded.maven.wagon.http.retryHandler.count", 3);
    private static final String RETRY_HANDLER_EXCEPTIONS = System.getProperty("io.quarkus.launcher.shaded.maven.wagon.http.retryHandler.nonRetryableClasses");
    private static final String SERVICE_UNAVAILABLE_RETRY_STRATEGY_CLASS = System.getProperty("io.quarkus.launcher.shaded.maven.wagon.http.serviceUnavailableRetryStrategy.class", "io.quarkus.launcher.shaded.none");
    private static final int SERVICE_UNAVAILABLE_RETRY_STRATEGY_RETRY_INTERVAL = Integer.getInteger("io.quarkus.launcher.shaded.maven.wagon.http.serviceUnavailableRetryStrategy.retryInterval", 1000);
    private static final int SERVICE_UNAVAILABLE_RETRY_STRATEGY_MAX_RETRIES = Integer.getInteger("io.quarkus.launcher.shaded.maven.wagon.http.serviceUnavailableRetryStrategy.maxRetries", 5);
    private static CloseableHttpClient httpClient = AbstractHttpClientWagon.createClient();
    private CredentialsProvider credentialsProvider;
    private AuthCache authCache;
    private Closeable closeable;
    private Properties httpHeaders;
    private HttpConfiguration httpConfiguration;
    private BasicAuthScope basicAuth;
    private BasicAuthScope proxyAuth;

    protected int backoff(int wait, String url) throws InterruptedException, TransferFailedException {
        TimeUnit.SECONDS.sleep(wait);
        int nextWait = wait * 2;
        if (nextWait >= AbstractHttpClientWagon.getMaxBackoffWaitSeconds()) {
            throw new TransferFailedException("io.quarkus.launcher.shaded.Waited too long to access: " + url + "io.quarkus.launcher.shaded.. Return code is: " + 429);
        }
        return nextWait;
    }

    private static PoolingHttpClientConnectionManager createConnManager() {
        SSLConnectionSocketFactory sslConnectionSocketFactory;
        String[] cipherSuites;
        String sslProtocolsStr = System.getProperty("io.quarkus.launcher.shaded.https.protocols");
        String cipherSuitesStr = System.getProperty("io.quarkus.launcher.shaded.https.cipherSuites");
        String[] sslProtocols = sslProtocolsStr != null ? sslProtocolsStr.split("io.quarkus.launcher.shaded. *, *") : null;
        String[] stringArray = cipherSuites = cipherSuitesStr != null ? cipherSuitesStr.split("io.quarkus.launcher.shaded. *, *") : null;
        if (SSL_INSECURE) {
            try {
                SSLContext sslContext = new SSLContextBuilder().useSSL().loadTrustMaterial(null, new RelaxedTrustStrategy(IGNORE_SSL_VALIDITY_DATES)).build();
                sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, sslProtocols, cipherSuites, SSL_ALLOW_ALL ? SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER : SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            }
            catch (Exception ex) {
                throw new SSLInitializationException(ex.getMessage(), ex);
            }
        } else {
            sslConnectionSocketFactory = new SSLConnectionSocketFactory(HttpsURLConnection.getDefaultSSLSocketFactory(), sslProtocols, cipherSuites, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        }
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("io.quarkus.launcher.shaded.http", PlainConnectionSocketFactory.INSTANCE).register("io.quarkus.launcher.shaded.https", (PlainConnectionSocketFactory)((Object)sslConnectionSocketFactory)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(registry, null, null, null, CONN_TTL, TimeUnit.SECONDS);
        if (persistentPool) {
            connManager.setDefaultMaxPerRoute(MAX_CONN_PER_ROUTE);
            connManager.setMaxTotal(MAX_CONN_TOTAL);
        } else {
            connManager.setMaxTotal(1);
        }
        return connManager;
    }

    private static HttpRequestRetryHandler createRetryHandler() {
        switch (RETRY_HANDLER_CLASS) {
            case "io.quarkus.launcher.shaded.default": {
                if (StringUtils.isEmpty(RETRY_HANDLER_EXCEPTIONS)) {
                    return new DefaultHttpRequestRetryHandler(RETRY_HANDLER_COUNT, RETRY_HANDLER_REQUEST_SENT_ENABLED);
                }
                return new DefaultHttpRequestRetryHandler(RETRY_HANDLER_COUNT, RETRY_HANDLER_REQUEST_SENT_ENABLED, (Collection)AbstractHttpClientWagon.getNonRetryableExceptions()){};
            }
            case "io.quarkus.launcher.shaded.standard": {
                return new StandardHttpRequestRetryHandler(RETRY_HANDLER_COUNT, RETRY_HANDLER_REQUEST_SENT_ENABLED);
            }
        }
        try {
            ClassLoader classLoader = AbstractHttpClientWagon.class.getClassLoader();
            return (HttpRequestRetryHandler)HttpRequestRetryHandler.class.cast(classLoader.loadClass(RETRY_HANDLER_CLASS).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static ServiceUnavailableRetryStrategy createServiceUnavailableRetryStrategy() {
        switch (SERVICE_UNAVAILABLE_RETRY_STRATEGY_CLASS) {
            case "io.quarkus.launcher.shaded.none": {
                return null;
            }
            case "io.quarkus.launcher.shaded.default": {
                return new DefaultServiceUnavailableRetryStrategy(SERVICE_UNAVAILABLE_RETRY_STRATEGY_MAX_RETRIES, SERVICE_UNAVAILABLE_RETRY_STRATEGY_RETRY_INTERVAL);
            }
            case "io.quarkus.launcher.shaded.standard": {
                return new StandardServiceUnavailableRetryStrategy(SERVICE_UNAVAILABLE_RETRY_STRATEGY_MAX_RETRIES, SERVICE_UNAVAILABLE_RETRY_STRATEGY_RETRY_INTERVAL);
            }
        }
        try {
            ClassLoader classLoader = AbstractHttpClientWagon.class.getClassLoader();
            return (ServiceUnavailableRetryStrategy)ServiceUnavailableRetryStrategy.class.cast(classLoader.loadClass(SERVICE_UNAVAILABLE_RETRY_STRATEGY_CLASS).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Registry<AuthSchemeProvider> createAuthSchemeRegistry() {
        return RegistryBuilder.create().register("io.quarkus.launcher.shaded.Basic", new BasicSchemeFactory(StandardCharsets.UTF_8)).register("io.quarkus.launcher.shaded.Digest", (BasicSchemeFactory)((Object)new DigestSchemeFactory(StandardCharsets.UTF_8))).register("io.quarkus.launcher.shaded.NTLM", (BasicSchemeFactory)((Object)new NTLMSchemeFactory())).build();
    }

    private static Collection<Class<? extends IOException>> getNonRetryableExceptions() {
        ArrayList<Class<? extends IOException>> exceptions = new ArrayList<Class<? extends IOException>>();
        ClassLoader loader = AbstractHttpClientWagon.class.getClassLoader();
        for (String ex : RETRY_HANDLER_EXCEPTIONS.split("io.quarkus.launcher.shaded.,")) {
            try {
                exceptions.add(loader.loadClass(ex));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return exceptions;
    }

    private static CloseableHttpClient createClient() {
        return HttpClientBuilder.create().useSystemProperties().disableConnectionState().setConnectionManager(httpClientConnectionManager).setRetryHandler(AbstractHttpClientWagon.createRetryHandler()).setServiceUnavailableRetryStrategy(AbstractHttpClientWagon.createServiceUnavailableRetryStrategy()).setDefaultAuthSchemeRegistry(AbstractHttpClientWagon.createAuthSchemeRegistry()).build();
    }

    @Override
    public void openConnectionInternal() {
        ProxyInfo proxyInfo;
        this.repository.setUrl(this.getURL(this.repository));
        this.credentialsProvider = new BasicCredentialsProvider();
        this.authCache = new BasicAuthCache();
        if (this.authenticationInfo != null) {
            String username = this.authenticationInfo.getUserName();
            String password = this.authenticationInfo.getPassword();
            if (StringUtils.isNotEmpty(username) && StringUtils.isNotEmpty(password)) {
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
                String host = this.getRepository().getHost();
                int port = this.getRepository().getPort();
                this.credentialsProvider.setCredentials(this.getBasicAuthScope().getScope(host, port), creds);
            }
        }
        if ((proxyInfo = this.getProxyInfo(this.getRepository().getProtocol(), this.getRepository().getHost())) != null) {
            String proxyUsername = proxyInfo.getUserName();
            String proxyPassword = proxyInfo.getPassword();
            String proxyHost = proxyInfo.getHost();
            String proxyNtlmHost = proxyInfo.getNtlmHost();
            String proxyNtlmDomain = proxyInfo.getNtlmDomain();
            if (proxyHost != null && proxyUsername != null && proxyPassword != null) {
                Credentials creds = proxyNtlmHost != null || proxyNtlmDomain != null ? new NTCredentials(proxyUsername, proxyPassword, proxyNtlmHost, proxyNtlmDomain) : new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                int proxyPort = proxyInfo.getPort();
                AuthScope authScope = this.getProxyBasicAuthScope().getScope(proxyHost, proxyPort);
                this.credentialsProvider.setCredentials(authScope, creds);
            }
        }
    }

    @Override
    public void closeConnection() {
        if (!persistentPool) {
            httpClientConnectionManager.closeIdleConnections(0L, TimeUnit.MILLISECONDS);
        }
        if (this.authCache != null) {
            this.authCache.clear();
            this.authCache = null;
        }
        if (this.credentialsProvider != null) {
            this.credentialsProvider.clear();
            this.credentialsProvider = null;
        }
    }

    public static CloseableHttpClient getHttpClient() {
        return httpClient;
    }

    public static void setPersistentPool(boolean persistentPool) {
    }

    public static void setPoolingHttpClientConnectionManager(PoolingHttpClientConnectionManager poolingHttpClientConnectionManager) {
        httpClientConnectionManager = poolingHttpClientConnectionManager;
        httpClient = AbstractHttpClientWagon.createClient();
    }

    @Override
    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.firePutInitiated(resource, source);
        resource.setContentLength(source.length());
        resource.setLastModified(source.lastModified());
        this.put(null, resource, source);
    }

    @Override
    public void putFromStream(InputStream stream, String destination, long contentLength, long lastModified) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(destination);
        this.firePutInitiated(resource, null);
        resource.setContentLength(contentLength);
        resource.setLastModified(lastModified);
        this.put(stream, resource, null);
    }

    private void put(InputStream stream, Resource resource, File source) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        this.put(resource, source, new WagonHttpEntity(stream, resource, this, source));
    }

    private void put(Resource resource, File source, HttpEntity httpEntity) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        this.put(resource, source, httpEntity, this.buildUrl(resource));
    }

    private String buildUrl(Resource resource) {
        return this.buildUrl(resource.getName());
    }

    private String buildUrl(String resourceName) {
        return EncodingUtil.encodeURLToString(this.getRepository().getUrl(), resourceName);
    }

    private void put(Resource resource, File source, HttpEntity httpEntity, String url) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        this.put(this.getInitialBackoffSeconds(), resource, source, httpEntity, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(int wait, Resource resource, File source, HttpEntity httpEntity, String url) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        try {
            this.mkdirs(PathUtils.dirname(resource.getName()));
        }
        catch (HttpException he) {
            this.fireTransferError(resource, he, 6);
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 6);
        }
        Repository repo = this.getRepository();
        HttpHost targetHost = new HttpHost(repo.getHost(), repo.getPort(), repo.getProtocol());
        AuthScope targetScope = this.getBasicAuthScope().getScope(targetHost);
        if (this.credentialsProvider.getCredentials(targetScope) != null) {
            BasicScheme targetAuth = new BasicScheme();
            this.authCache.put(targetHost, targetAuth);
        }
        HttpPut putMethod = new HttpPut(url);
        this.firePutStarted(resource, source);
        try {
            putMethod.setEntity(httpEntity);
            try (CloseableHttpResponse response = this.execute(putMethod);){
                this.fireTransferDebug(HttpMessageUtils.formatTransferDebugMessage(url, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), this.getProxyInfo()));
                int statusCode = response.getStatusLine().getStatusCode();
                switch (statusCode) {
                    case 200: 
                    case 201: 
                    case 202: 
                    case 204: {
                        break;
                    }
                    case 301: 
                    case 302: 
                    case 303: {
                        this.put(resource, source, httpEntity, this.calculateRelocatedUrl(response));
                        return;
                    }
                    case 403: {
                        this.fireSessionConnectionRefused();
                        throw new AuthorizationException(HttpMessageUtils.formatAuthorizationMessage(url, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), this.getProxyInfo()));
                    }
                    case 404: {
                        throw new ResourceDoesNotExistException(HttpMessageUtils.formatResourceDoesNotExistMessage(url, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), this.getProxyInfo()));
                    }
                    case 429: {
                        this.put(this.backoff(wait, url), resource, source, httpEntity, url);
                        break;
                    }
                    default: {
                        TransferFailedException e = new TransferFailedException(HttpMessageUtils.formatTransferFailedMessage(url, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), this.getProxyInfo()));
                        this.fireTransferError(resource, e, 6);
                        throw e;
                    }
                }
                this.firePutCompleted(resource, source);
                EntityUtils.consume(response.getEntity());
            }
        }
        catch (HttpException | IOException | InterruptedException e) {
            this.fireTransferError(resource, e, 6);
            throw new TransferFailedException(HttpMessageUtils.formatTransferFailedMessage(url, this.getProxyInfo()), e);
        }
    }

    protected String calculateRelocatedUrl(HttpResponse response) {
        Header locationHeader = response.getFirstHeader("io.quarkus.launcher.shaded.Location");
        String locationField = locationHeader.getValue();
        return locationField.startsWith("io.quarkus.launcher.shaded.http") ? locationField : this.getURL(this.getRepository()) + '/' + locationField;
    }

    protected void mkdirs(String dirname) throws HttpException, IOException {
    }

    @Override
    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        return this.resourceExists(this.getInitialBackoffSeconds(), resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean resourceExists(int wait, String resourceName) throws TransferFailedException, AuthorizationException {
        String url = this.buildUrl(resourceName);
        HttpHead headMethod = new HttpHead(url);
        try (CloseableHttpResponse response = this.execute(headMethod);){
            boolean result;
            int statusCode = response.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 200: {
                    result = true;
                    break;
                }
                case 304: {
                    result = true;
                    break;
                }
                case 401: 
                case 403: 
                case 407: {
                    throw new AuthorizationException(HttpMessageUtils.formatAuthorizationMessage(url, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), this.getProxyInfo()));
                }
                case 404: {
                    result = false;
                    break;
                }
                case 429: {
                    boolean bl = this.resourceExists(this.backoff(wait, resourceName), resourceName);
                    return bl;
                }
                default: {
                    throw new TransferFailedException(HttpMessageUtils.formatTransferFailedMessage(url, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), this.getProxyInfo()));
                }
            }
            EntityUtils.consume(response.getEntity());
            boolean bl = result;
            return bl;
        }
        catch (HttpException | IOException | InterruptedException e) {
            throw new TransferFailedException(HttpMessageUtils.formatTransferFailedMessage(url, this.getProxyInfo()), e);
        }
    }

    protected CloseableHttpResponse execute(HttpUriRequest httpMethod) throws HttpException, IOException {
        HttpMethodConfiguration config;
        this.setHeaders(httpMethod);
        String userAgent = this.getUserAgent(httpMethod);
        if (userAgent != null) {
            httpMethod.setHeader("io.quarkus.launcher.shaded.User-Agent", userAgent);
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setCookieSpec("io.quarkus.launcher.shaded.compatibility");
        Repository repo = this.getRepository();
        ProxyInfo proxyInfo = this.getProxyInfo(repo.getProtocol(), repo.getHost());
        if (proxyInfo != null) {
            HttpHost proxy = new HttpHost(proxyInfo.getHost(), proxyInfo.getPort());
            requestConfigBuilder.setProxy(proxy);
        }
        HttpMethodConfiguration httpMethodConfiguration = config = this.httpConfiguration == null ? null : this.httpConfiguration.getMethodConfiguration(httpMethod);
        if (config != null) {
            ConfigurationUtils.copyConfig(config, requestConfigBuilder);
        } else {
            requestConfigBuilder.setSocketTimeout(this.getReadTimeout());
            if (httpMethod instanceof HttpPut) {
                requestConfigBuilder.setExpectContinueEnabled(true);
            }
        }
        if (httpMethod instanceof HttpPut) {
            requestConfigBuilder.setRedirectsEnabled(false);
        }
        HttpClientContext localContext = HttpClientContext.create();
        localContext.setCredentialsProvider(this.credentialsProvider);
        localContext.setAuthCache(this.authCache);
        localContext.setRequestConfig(requestConfigBuilder.build());
        if (config != null && config.isUsePreemptive()) {
            HttpHost targetHost = new HttpHost(repo.getHost(), repo.getPort(), repo.getProtocol());
            AuthScope targetScope = this.getBasicAuthScope().getScope(targetHost);
            if (this.credentialsProvider.getCredentials(targetScope) != null) {
                BasicScheme targetAuth = new BasicScheme();
                this.authCache.put(targetHost, targetAuth);
            }
        }
        if (proxyInfo != null && proxyInfo.getHost() != null) {
            HttpHost proxyHost = new HttpHost(proxyInfo.getHost(), proxyInfo.getPort());
            AuthScope proxyScope = this.getProxyBasicAuthScope().getScope(proxyHost);
            if (this.credentialsProvider.getCredentials(proxyScope) != null) {
                BasicScheme proxyAuth = new BasicScheme(ChallengeState.PROXY);
                this.authCache.put(proxyHost, proxyAuth);
            }
        }
        return httpClient.execute(httpMethod, localContext);
    }

    public void setHeaders(HttpUriRequest method) {
        String userAgent;
        Header userAgentHeader;
        Header[] headers;
        HttpMethodConfiguration config;
        HttpMethodConfiguration httpMethodConfiguration = config = this.httpConfiguration == null ? null : this.httpConfiguration.getMethodConfiguration(method);
        if (config == null || config.isUseDefaultHeaders()) {
            method.addHeader("io.quarkus.launcher.shaded.Cache-control", "io.quarkus.launcher.shaded.no-cache");
            method.addHeader("io.quarkus.launcher.shaded.Cache-store", "io.quarkus.launcher.shaded.no-store");
            method.addHeader("io.quarkus.launcher.shaded.Pragma", "io.quarkus.launcher.shaded.no-cache");
        }
        if (this.httpHeaders != null) {
            for (Map.Entry<Object, Object> entry : this.httpHeaders.entrySet()) {
                method.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        Header[] headerArray = headers = config == null ? null : config.asRequestHeaders();
        if (headers != null) {
            for (Header header : headers) {
                method.setHeader(header);
            }
        }
        if ((userAgentHeader = method.getFirstHeader("io.quarkus.launcher.shaded.User-Agent")) == null && (userAgent = this.getUserAgent(method)) != null) {
            method.setHeader("io.quarkus.launcher.shaded.User-Agent", userAgent);
        }
    }

    protected String getUserAgent(HttpUriRequest method) {
        HttpMethodConfiguration config;
        String value;
        if (this.httpHeaders != null && (value = (String)this.httpHeaders.get("io.quarkus.launcher.shaded.User-Agent")) != null) {
            return value;
        }
        HttpMethodConfiguration httpMethodConfiguration = config = this.httpConfiguration == null ? null : this.httpConfiguration.getMethodConfiguration(method);
        if (config != null) {
            return (String)config.getHeaders().get("io.quarkus.launcher.shaded.User-Agent");
        }
        return null;
    }

    protected String getURL(Repository repository) {
        return repository.getUrl();
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    public void setHttpConfiguration(HttpConfiguration httpConfiguration) {
        this.httpConfiguration = httpConfiguration;
    }

    public BasicAuthScope getBasicAuthScope() {
        if (this.basicAuth == null) {
            this.basicAuth = new BasicAuthScope();
        }
        return this.basicAuth;
    }

    public void setBasicAuthScope(BasicAuthScope basicAuth) {
        this.basicAuth = basicAuth;
    }

    public BasicAuthScope getProxyBasicAuthScope() {
        if (this.proxyAuth == null) {
            this.proxyAuth = new BasicAuthScope();
        }
        return this.proxyAuth;
    }

    public void setProxyBasicAuthScope(BasicAuthScope proxyAuth) {
        this.proxyAuth = proxyAuth;
    }

    @Override
    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.fillInputData(this.getInitialBackoffSeconds(), inputData);
    }

    private void fillInputData(int wait, InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = inputData.getResource();
        String url = this.buildUrl(resource);
        HttpGet getMethod = new HttpGet(url);
        long timestamp = resource.getLastModified();
        if (timestamp > 0L) {
            SimpleDateFormat fmt = new SimpleDateFormat("io.quarkus.launcher.shaded.EEE, dd-MMM-yy HH:mm:ss zzz", Locale.US);
            fmt.setTimeZone(GMT_TIME_ZONE);
            BasicHeader hdr = new BasicHeader("io.quarkus.launcher.shaded.If-Modified-Since", fmt.format(new Date(timestamp)));
            this.fireTransferDebug("io.quarkus.launcher.shaded.sending ==> " + hdr + "io.quarkus.launcher.shaded.(" + timestamp + "io.quarkus.launcher.shaded.)");
            getMethod.addHeader(hdr);
        }
        try {
            HttpEntity entity;
            Date lastModified;
            Header lastModifiedHeader;
            CloseableHttpResponse response = this.execute(getMethod);
            this.closeable = response;
            this.fireTransferDebug(HttpMessageUtils.formatTransferDebugMessage(url, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), this.getProxyInfo()));
            int statusCode = response.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 200: {
                    break;
                }
                case 304: {
                    return;
                }
                case 401: 
                case 403: 
                case 407: {
                    this.fireSessionConnectionRefused();
                    throw new AuthorizationException(HttpMessageUtils.formatAuthorizationMessage(url, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), this.getProxyInfo()));
                }
                case 404: {
                    throw new ResourceDoesNotExistException(HttpMessageUtils.formatResourceDoesNotExistMessage(url, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), this.getProxyInfo()));
                }
                case 429: {
                    this.fillInputData(this.backoff(wait, url), inputData);
                    break;
                }
                default: {
                    this.cleanupGetTransfer(resource);
                    TransferFailedException e = new TransferFailedException(HttpMessageUtils.formatTransferFailedMessage(url, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), this.getProxyInfo()));
                    this.fireTransferError(resource, e, 5);
                    throw e;
                }
            }
            Header contentLengthHeader = response.getFirstHeader("io.quarkus.launcher.shaded.Content-Length");
            if (contentLengthHeader != null) {
                try {
                    long contentLength = Long.parseLong(contentLengthHeader.getValue());
                    resource.setContentLength(contentLength);
                }
                catch (NumberFormatException e) {
                    this.fireTransferDebug("io.quarkus.launcher.shaded.error parsing content length header '" + contentLengthHeader.getValue() + "io.quarkus.launcher.shaded.' " + e);
                }
            }
            if ((lastModifiedHeader = response.getFirstHeader("io.quarkus.launcher.shaded.Last-Modified")) != null && (lastModified = DateUtils.parseDate(lastModifiedHeader.getValue())) != null) {
                resource.setLastModified(lastModified.getTime());
                this.fireTransferDebug("io.quarkus.launcher.shaded.last-modified = " + lastModifiedHeader.getValue() + "io.quarkus.launcher.shaded. (" + lastModified.getTime() + "io.quarkus.launcher.shaded.)");
            }
            if ((entity = response.getEntity()) != null) {
                inputData.setInputStream(entity.getContent());
            }
        }
        catch (HttpException | IOException | InterruptedException e) {
            this.fireTransferError(resource, e, 5);
            throw new TransferFailedException(HttpMessageUtils.formatTransferFailedMessage(url, this.getProxyInfo()), e);
        }
    }

    @Override
    protected void cleanupGetTransfer(Resource resource) {
        if (this.closeable != null) {
            try {
                this.closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void putFromStream(InputStream stream, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.putFromStream(stream, destination, -1L, -1L);
    }

    @Override
    protected void putFromStream(InputStream stream, Resource resource) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        this.putFromStream(stream, resource.getName(), -1L, -1L);
    }

    public Properties getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(Properties httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    @Override
    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        throw new IllegalStateException("io.quarkus.launcher.shaded.this wagon http client must not use fillOutputData");
    }

    protected CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    protected AuthCache getAuthCache() {
        return this.authCache;
    }

    public int getInitialBackoffSeconds() {
        return this.initialBackoffSeconds;
    }

    public void setInitialBackoffSeconds(int initialBackoffSeconds) {
        this.initialBackoffSeconds = initialBackoffSeconds;
    }

    public static int getMaxBackoffWaitSeconds() {
        return MAX_BACKOFF_WAIT_SECONDS;
    }

    private final class WagonHttpEntity
    extends AbstractHttpEntity {
        private final Resource resource;
        private final Wagon wagon;
        private InputStream stream;
        private File source;
        private long length = -1L;
        private boolean repeatable;

        private WagonHttpEntity(InputStream stream, Resource resource, Wagon wagon, File source) throws TransferFailedException {
            if (source != null) {
                this.source = source;
                this.repeatable = true;
            } else {
                this.stream = stream;
                this.repeatable = false;
            }
            this.resource = resource;
            this.length = resource == null ? -1L : resource.getContentLength();
            this.wagon = wagon;
        }

        @Override
        public long getContentLength() {
            return this.length;
        }

        @Override
        public InputStream getContent() throws IOException, IllegalStateException {
            if (this.source != null) {
                return new FileInputStream(this.source);
            }
            return this.stream;
        }

        @Override
        public boolean isRepeatable() {
            return this.repeatable;
        }

        @Override
        public void writeTo(OutputStream output) throws IOException {
            if (output == null) {
                throw new NullPointerException("io.quarkus.launcher.shaded.output cannot be null");
            }
            TransferEvent transferEvent = new TransferEvent(this.wagon, this.resource, 3, 6);
            transferEvent.setTimestamp(System.currentTimeMillis());
            try (ReadableByteChannel input = this.source != null ? new RandomAccessFile(this.source, "io.quarkus.launcher.shaded.r").getChannel() : Channels.newChannel(this.stream);){
                long remaining;
                ByteBuffer buffer = ByteBuffer.allocate(AbstractHttpClientWagon.this.getBufferCapacityForTransfer(this.length));
                int halfBufferCapacity = buffer.capacity() / 2;
                long l = remaining = this.length < 0L ? Long.MAX_VALUE : this.length;
                while (remaining > 0L) {
                    int read = input.read(buffer);
                    if (read == -1) {
                        if (buffer.position() == 0) break;
                        buffer.flip();
                        AbstractHttpClientWagon.this.fireTransferProgress(transferEvent, buffer.array(), buffer.limit());
                        output.write(buffer.array(), 0, buffer.limit());
                        buffer.clear();
                        break;
                    }
                    if (buffer.position() < halfBufferCapacity) continue;
                    buffer.flip();
                    AbstractHttpClientWagon.this.fireTransferProgress(transferEvent, buffer.array(), buffer.limit());
                    output.write(buffer.array(), 0, buffer.limit());
                    remaining -= (long)buffer.limit();
                    buffer.clear();
                }
                output.flush();
            }
        }

        @Override
        public boolean isStreaming() {
            return true;
        }
    }
}

