/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.wagon.shared.http;

import io.quarkus.launcher.shaded.org.apache.commons.io.IOUtils;
import io.quarkus.launcher.shaded.org.apache.maven.wagon.TransferFailedException;
import io.quarkus.launcher.shaded.org.jsoup.Jsoup;
import io.quarkus.launcher.shaded.org.jsoup.nodes.Document;
import io.quarkus.launcher.shaded.org.jsoup.nodes.Element;
import io.quarkus.launcher.shaded.org.jsoup.select.Elements;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public class HtmlFileListParser {
    private static final Pattern APACHE_INDEX_SKIP = Pattern.compile("io.quarkus.launcher.shaded.\\?[CDMNS]=.*");
    private static final Pattern URLS_WITH_PATHS = Pattern.compile("io/quarkus/launcher/shaded//[^/]*/");
    private static final Pattern URLS_TO_PARENT = Pattern.compile("io/quarkus/launcher/shaded/\\.\\./");
    private static final Pattern MAILTO_URLS = Pattern.compile("io.quarkus.launcher.shaded.mailto:.*");
    private static final Pattern[] SKIPS = new Pattern[]{APACHE_INDEX_SKIP, URLS_WITH_PATHS, URLS_TO_PARENT, MAILTO_URLS};

    public static List<String> parseFileList(String baseurl, InputStream stream) throws TransferFailedException {
        try {
            URI baseURI = new URI(baseurl);
            String content = IOUtils.toString(stream, "io.quarkus.launcher.shaded.utf-8");
            Document doc = Jsoup.parse(content, baseurl);
            Elements links = doc.select("io.quarkus.launcher.shaded.a[href]");
            HashSet<String> results = new HashSet<String>();
            for (Element link : links) {
                String clean;
                String target = link.attr("io.quarkus.launcher.shaded.href");
                if (target == null || !HtmlFileListParser.isAcceptableLink(clean = HtmlFileListParser.cleanLink(baseURI, target))) continue;
                results.add(clean);
            }
            return new ArrayList<String>(results);
        }
        catch (URISyntaxException e) {
            throw new TransferFailedException("io.quarkus.launcher.shaded.Unable to parse as base URI: " + baseurl, e);
        }
        catch (IOException e) {
            throw new TransferFailedException("io/quarkus/launcher/shaded/I/O error reading HTML listing of artifacts: " + e.getMessage(), e);
        }
    }

    private static String cleanLink(URI baseURI, String link) {
        if (link == null || link.length() == 0) {
            return "io.quarkus.launcher.shaded.";
        }
        String ret = link;
        try {
            URI relativeURI;
            URI linkuri = new URI(ret);
            if (link.startsWith("io/quarkus/launcher/shaded//")) {
                linkuri = baseURI.resolve(linkuri);
            }
            if ((ret = (relativeURI = baseURI.relativize(linkuri).normalize()).toASCIIString()).startsWith(baseURI.getPath())) {
                ret = ret.substring(baseURI.getPath().length());
            }
            ret = URLDecoder.decode(ret, "io.quarkus.launcher.shaded.UTF-8");
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    private static boolean isAcceptableLink(String link) {
        if (link == null || link.length() == 0) {
            return false;
        }
        for (Pattern pattern : SKIPS) {
            if (!pattern.matcher(link).find()) continue;
            return false;
        }
        return true;
    }
}

