/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.wagon.shared.http;

import io.quarkus.launcher.shaded.org.apache.maven.wagon.proxy.ProxyInfo;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.StringUtils;

public class HttpMessageUtils {
    private static final int SC_UNAUTHORIZED = 401;
    private static final int SC_FORBIDDEN = 403;
    private static final int SC_NOT_FOUND = 404;
    private static final int SC_PROXY_AUTH_REQUIRED = 407;
    private static final int SC_GONE = 410;
    public static final int UNKNOWN_STATUS_CODE = -1;

    public static String formatTransferDebugMessage(String url, int statusCode, String reasonPhrase, ProxyInfo proxyInfo) {
        String msg = url;
        if (statusCode != -1) {
            msg = msg + "io.quarkus.launcher.shaded. -- status code: " + statusCode;
            if (StringUtils.isNotEmpty(reasonPhrase)) {
                msg = msg + "io.quarkus.launcher.shaded., reason phrase: " + reasonPhrase;
            }
        }
        if (proxyInfo != null) {
            msg = msg + "io.quarkus.launcher.shaded. -- " + proxyInfo.toString();
        }
        return msg;
    }

    public static String formatTransferFailedMessage(String url, ProxyInfo proxyInfo) {
        return HttpMessageUtils.formatTransferFailedMessage(url, -1, null, proxyInfo);
    }

    public static String formatTransferFailedMessage(String url, int statusCode, String reasonPhrase, ProxyInfo proxyInfo) {
        return HttpMessageUtils.formatMessage("io.quarkus.launcher.shaded.Transfer failed for ", url, statusCode, reasonPhrase, proxyInfo);
    }

    public static String formatAuthorizationMessage(String url, int statusCode, String reasonPhrase, ProxyInfo proxyInfo) {
        switch (statusCode) {
            case 401: {
                return HttpMessageUtils.formatMessage("io.quarkus.launcher.shaded.Authentication failed for ", url, statusCode, reasonPhrase, null);
            }
            case 403: {
                return HttpMessageUtils.formatMessage("io.quarkus.launcher.shaded.Authorization failed for ", url, statusCode, reasonPhrase, null);
            }
            case 407: {
                return HttpMessageUtils.formatMessage("io.quarkus.launcher.shaded.HTTP proxy server authentication failed for ", url, statusCode, reasonPhrase, null);
            }
        }
        return HttpMessageUtils.formatMessage("io.quarkus.launcher.shaded.Authorization failed for ", url, statusCode, reasonPhrase, proxyInfo);
    }

    public static String formatResourceDoesNotExistMessage(String url, int statusCode, String reasonPhrase, ProxyInfo proxyInfo) {
        return HttpMessageUtils.formatMessage("io.quarkus.launcher.shaded.Resource missing at ", url, statusCode, reasonPhrase, proxyInfo);
    }

    private static String formatMessage(String message, String url, int statusCode, String reasonPhrase, ProxyInfo proxyInfo) {
        String msg = message + url;
        if (statusCode != -1) {
            msg = msg + "io.quarkus.launcher.shaded. " + statusCode;
            if (StringUtils.isNotEmpty(reasonPhrase)) {
                msg = msg + "io.quarkus.launcher.shaded. " + reasonPhrase;
            } else {
                switch (statusCode) {
                    case 401: {
                        msg = msg + "io.quarkus.launcher.shaded. Unauthorized";
                        break;
                    }
                    case 403: {
                        msg = msg + "io.quarkus.launcher.shaded. Forbidden";
                        break;
                    }
                    case 404: {
                        msg = msg + "io.quarkus.launcher.shaded. Not Found";
                        break;
                    }
                    case 407: {
                        msg = msg + "io.quarkus.launcher.shaded. Proxy Authentication Required";
                        break;
                    }
                    case 410: {
                        msg = msg + "io.quarkus.launcher.shaded. Gone";
                        break;
                    }
                }
            }
        }
        if (proxyInfo != null) {
            msg = msg + "io.quarkus.launcher.shaded. " + proxyInfo.toString();
        }
        return msg;
    }
}

