/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.maven.wagon.shared.http;

import io.quarkus.launcher.shaded.org.apache.http.HttpResponse;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.client.ServiceUnavailableRetryStrategy;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HttpContext;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class StandardServiceUnavailableRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private final int maxRetries;
    private final long retryInterval;

    public StandardServiceUnavailableRetryStrategy(int maxRetries, int retryInterval) {
        Args.positive(maxRetries, "io.quarkus.launcher.shaded.Max retries");
        Args.positive(retryInterval, "io.quarkus.launcher.shaded.Retry interval");
        this.maxRetries = maxRetries;
        this.retryInterval = retryInterval;
    }

    @Override
    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        int statusCode = response.getStatusLine().getStatusCode();
        boolean retryableStatusCode = statusCode == 408 || statusCode == 429 || statusCode == 500 || statusCode == 502 || statusCode == 503 || statusCode == 504;
        return executionCount <= this.maxRetries && retryableStatusCode;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }
}

