/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters;

import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import io.quarkus.launcher.shaded.org.codehaus.plexus.configuration.PlexusConfiguration;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.Roles;
import java.lang.reflect.Array;

public abstract class AbstractConfigurationConverter
implements ConfigurationConverter {
    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator) throws ComponentConfigurationException {
        return this.fromConfiguration(lookup, configuration, type, enclosingType, loader, evaluator, null);
    }

    protected Object fromExpression(PlexusConfiguration configuration, ExpressionEvaluator evaluator) throws ComponentConfigurationException {
        String value = configuration.getValue();
        try {
            Object result = null;
            if (value != null && value.length() > 0) {
                result = evaluator.evaluate(value);
            }
            if (result == null && configuration.getChildCount() == 0 && (value = configuration.getAttribute("io.quarkus.launcher.shaded.default-value")) != null && value.length() > 0) {
                result = evaluator.evaluate(value);
            }
            return result;
        }
        catch (ExpressionEvaluationException e) {
            String reason = String.format("io.quarkus.launcher.shaded.Cannot evaluate expression '%s' for configuration entry '%s'", value, configuration.getName());
            throw new ComponentConfigurationException(configuration, reason, e);
        }
    }

    protected Object fromExpression(PlexusConfiguration configuration, ExpressionEvaluator evaluator, Class<?> type) throws ComponentConfigurationException {
        Object result = this.fromExpression(configuration, evaluator);
        this.failIfNotTypeCompatible(result, type, configuration);
        return result;
    }

    protected final String fromXML(String name) {
        return Roles.camelizeName(name);
    }

    protected final void failIfNotTypeCompatible(Object value, Class<?> type, PlexusConfiguration configuration) throws ComponentConfigurationException {
        if (value != null && type != null && !type.isInstance(value)) {
            String reason = String.format("io.quarkus.launcher.shaded.Cannot assign configuration entry '%s' with value '%s' of type %s to property of type %s", configuration.getName(), configuration.getValue(), value.getClass().getCanonicalName(), type.getCanonicalName());
            throw new ComponentConfigurationException(configuration, reason);
        }
    }

    protected final Class<?> getClassForImplementationHint(Class<?> type, PlexusConfiguration configuration, ClassLoader loader) throws ComponentConfigurationException {
        String hint = configuration.getAttribute("io.quarkus.launcher.shaded.implementation");
        if (hint == null) {
            return type;
        }
        try {
            int dims = 0;
            while (hint.endsWith("io.quarkus.launcher.shaded.[]")) {
                hint = hint.substring(0, hint.length() - 2);
                ++dims;
            }
            Class<?> implType = loader.loadClass(hint);
            while (dims > 0) {
                implType = Array.newInstance(implType, 0).getClass();
                --dims;
            }
            return implType;
        }
        catch (Exception e) {
            throw new ComponentConfigurationException("io.quarkus.launcher.shaded.Cannot load implementation hint '" + hint + "io.quarkus.launcher.shaded.'", (Throwable)e);
        }
        catch (LinkageError e) {
            throw new ComponentConfigurationException("io.quarkus.launcher.shaded.Cannot load implementation hint '" + hint + "io.quarkus.launcher.shaded.'", (Throwable)e);
        }
    }

    protected final Object instantiateObject(Class<?> type) throws ComponentConfigurationException {
        try {
            return type.newInstance();
        }
        catch (Exception e) {
            throw new ComponentConfigurationException("io.quarkus.launcher.shaded.Cannot create instance of " + type, (Throwable)e);
        }
        catch (LinkageError e) {
            throw new ComponentConfigurationException("io.quarkus.launcher.shaded.Cannot create instance of " + type, (Throwable)e);
        }
    }
}

