/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.basic;

import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.ConfigurationListener;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import io.quarkus.launcher.shaded.org.codehaus.plexus.configuration.PlexusConfiguration;

public class EnumConverter
extends AbstractConfigurationConverter {
    @Override
    public boolean canConvert(Class<?> type) {
        return type.isEnum();
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        if (configuration.getChildCount() > 0) {
            throw new ComponentConfigurationException("io.quarkus.launcher.shaded.Basic element '" + configuration.getName() + "io.quarkus.launcher.shaded.' must not contain child elements");
        }
        Object result = this.fromExpression(configuration, evaluator);
        if (result instanceof String) {
            try {
                result = Enum.valueOf(type, (String)result);
            }
            catch (RuntimeException e) {
                throw new ComponentConfigurationException("io.quarkus.launcher.shaded.Cannot convert '" + result + "io.quarkus.launcher.shaded.' to Enum", (Throwable)e);
            }
        }
        return result;
    }
}

