/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.composite;

import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.ConfigurationListener;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.composite.AbstractCollectionConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import io.quarkus.launcher.shaded.org.codehaus.plexus.configuration.PlexusConfiguration;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class ArrayConverter
extends AbstractCollectionConverter {
    @Override
    public boolean canConvert(Class<?> type) {
        return type.isArray();
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value = this.fromExpression(configuration, evaluator);
        if (type.isInstance(value)) {
            return value;
        }
        try {
            Collection<Object> elements;
            Class<?> elementType = type.getComponentType();
            if (value == null) {
                elements = this.fromChildren(lookup, configuration, type, enclosingType, loader, evaluator, listener, elementType);
            } else if (value instanceof String) {
                PlexusConfiguration xml = ArrayConverter.csvToXml(configuration, (String)value);
                elements = this.fromChildren(lookup, xml, type, enclosingType, loader, evaluator, listener, elementType);
            } else if (value instanceof Collection) {
                elements = (Collection<Object>)value;
            } else {
                this.failIfNotTypeCompatible(value, type, configuration);
                elements = Collections.emptyList();
            }
            return elements.toArray((Object[])Array.newInstance(elementType, elements.size()));
        }
        catch (ComponentConfigurationException e) {
            if (e.getFailedConfiguration() == null) {
                e.setFailedConfiguration(configuration);
            }
            throw e;
        }
        catch (ArrayStoreException e) {
            throw new ComponentConfigurationException(configuration, "io.quarkus.launcher.shaded.Cannot store value into array", e);
        }
    }

    @Override
    protected final Collection<Object> instantiateCollection(PlexusConfiguration configuration, Class<?> type, ClassLoader loader) {
        return new ArrayList<Object>(configuration.getChildCount());
    }
}

