/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.lookup;

import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.basic.BooleanConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.basic.ByteConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.basic.CharConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.basic.DateConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.basic.DoubleConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.basic.EnumConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.basic.FileConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.basic.FloatConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.basic.IntConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.basic.LongConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.basic.ShortConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.basic.StringBufferConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.basic.StringBuilderConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.basic.StringConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.basic.UriConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.basic.UrlConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.composite.ArrayConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.composite.CollectionConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.composite.MapConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.composite.ObjectWithFieldsConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.composite.PlexusConfigurationConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.composite.PropertiesConverter;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import io.quarkus.launcher.shaded.org.codehaus.plexus.component.configurator.converters.special.ClassRealmConverter;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.Weak;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public final class DefaultConverterLookup
implements ConverterLookup {
    private static final ConfigurationConverter[] DEFAULT_CONVERTERS = new ConfigurationConverter[]{new FileConverter(), new BooleanConverter(), new StringConverter(), new IntConverter(), new CollectionConverter(), new ArrayConverter(), new MapConverter(), new PropertiesConverter(), new UrlConverter(), new UriConverter(), new DateConverter(), new EnumConverter(), new LongConverter(), new FloatConverter(), new DoubleConverter(), new CharConverter(), new ByteConverter(), new ShortConverter(), new PlexusConfigurationConverter(), new ClassRealmConverter(), new StringBufferConverter(), new StringBuilderConverter(), new ObjectWithFieldsConverter()};
    private final Map<Class<?>, ConfigurationConverter> lookupCache = Weak.concurrentKeys();
    private final List<ConfigurationConverter> customConverters = new CopyOnWriteArrayList<ConfigurationConverter>();

    @Override
    public void registerConverter(ConfigurationConverter converter) {
        this.customConverters.add(converter);
    }

    @Override
    public ConfigurationConverter lookupConverterForType(Class<?> type) throws ComponentConfigurationException {
        ConfigurationConverter converter = this.lookupCache.get(type);
        if (converter != null) {
            return converter;
        }
        int i = 0;
        while (i < this.customConverters.size()) {
            converter = this.customConverters.get(i);
            if (converter.canConvert(type)) {
                this.lookupCache.put(type, converter);
                return converter;
            }
            ++i;
        }
        i = 0;
        while (i < DEFAULT_CONVERTERS.length) {
            converter = DEFAULT_CONVERTERS[i];
            if (converter.canConvert(type)) {
                this.lookupCache.put(type, converter);
                return converter;
            }
            ++i;
        }
        throw new ComponentConfigurationException("io.quarkus.launcher.shaded.Cannot find converter for type: " + type);
    }

    void setCustomConverters(List<ConfigurationConverter> converters) {
        this.customConverters.addAll(converters);
    }
}

