/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.codehaus.plexus.logging;

import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.AbstractLoggerManager;
import io.quarkus.launcher.shaded.org.codehaus.plexus.logging.Logger;
import io.quarkus.launcher.shaded.org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import io.quarkus.launcher.shaded.org.eclipse.sisu.inject.Weak;
import io.quarkus.launcher.shaded.org.eclipse.sisu.plexus.Roles;
import java.util.Map;

public abstract class BaseLoggerManager
extends AbstractLoggerManager
implements Initializable {
    private final Map<String, Logger> activeLoggers = Weak.values();
    String threshold = "io.quarkus.launcher.shaded.INFO";
    private int currentThreshold;

    @Override
    public final void initialize() {
        this.currentThreshold = BaseLoggerManager.parseThreshold(this.threshold);
    }

    @Override
    public final synchronized Logger getLoggerForComponent(String role, String hint) {
        String name = Roles.canonicalRoleHint(role, hint);
        Logger logger = this.activeLoggers.get(name);
        if (logger == null) {
            logger = this.createLogger(name);
            logger.setThreshold(this.currentThreshold);
            this.activeLoggers.put(name, logger);
        }
        return logger;
    }

    @Override
    public final synchronized void returnComponentLogger(String role, String hint) {
        this.activeLoggers.remove(Roles.canonicalRoleHint(role, hint));
    }

    @Override
    public final int getThreshold() {
        return this.currentThreshold;
    }

    @Override
    public final void setThreshold(int currentThreshold) {
        this.currentThreshold = currentThreshold;
    }

    @Override
    public final synchronized void setThresholds(int currentThreshold) {
        this.currentThreshold = currentThreshold;
        for (Logger logger : this.activeLoggers.values()) {
            logger.setThreshold(currentThreshold);
        }
    }

    public static final int parseThreshold(String text) {
        if ("io.quarkus.launcher.shaded.DEBUG".equalsIgnoreCase(text)) {
            return 0;
        }
        if ("io.quarkus.launcher.shaded.INFO".equalsIgnoreCase(text)) {
            return 1;
        }
        if ("io.quarkus.launcher.shaded.WARN".equalsIgnoreCase(text)) {
            return 2;
        }
        if ("io.quarkus.launcher.shaded.ERROR".equalsIgnoreCase(text)) {
            return 3;
        }
        if ("io.quarkus.launcher.shaded.FATAL".equalsIgnoreCase(text)) {
            return 4;
        }
        if ("io.quarkus.launcher.shaded.DISABLED".equalsIgnoreCase(text)) {
            return 5;
        }
        return 0;
    }

    @Override
    public final synchronized int getActiveLoggerCount() {
        return this.activeLoggers.size();
    }

    protected abstract Logger createLogger(String var1);
}

