/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.codehaus.plexus.util;

import io.quarkus.launcher.shaded.org.codehaus.plexus.util.StringUtils;
import java.io.File;
import java.util.StringTokenizer;

public class PathTool {
    public static final String getRelativePath(String basedir, String filename) {
        basedir = PathTool.uppercaseDrive(basedir);
        filename = PathTool.uppercaseDrive(filename);
        if (basedir == null || basedir.length() == 0 || filename == null || filename.length() == 0 || !filename.startsWith(basedir)) {
            return "io.quarkus.launcher.shaded.";
        }
        String separator = PathTool.determineSeparator(filename);
        basedir = StringUtils.chompLast(basedir, separator);
        filename = StringUtils.chompLast(filename, separator);
        String relativeFilename = filename.substring(basedir.length());
        return PathTool.determineRelativePath(relativeFilename, separator);
    }

    public static final String getRelativePath(String filename) {
        if ((filename = PathTool.uppercaseDrive(filename)) == null || filename.length() == 0) {
            return "io.quarkus.launcher.shaded.";
        }
        String separator = PathTool.determineSeparator(filename);
        if (!(filename = StringUtils.chompLast(filename, separator)).startsWith(separator)) {
            filename = separator + filename;
        }
        return PathTool.determineRelativePath(filename, separator);
    }

    public static final String getDirectoryComponent(String filename) {
        if (filename == null || filename.length() == 0) {
            return "io.quarkus.launcher.shaded.";
        }
        String separator = PathTool.determineSeparator(filename);
        String directory = StringUtils.chomp(filename, separator);
        if (filename.equals(directory)) {
            return "io.quarkus.launcher.shaded..";
        }
        return directory;
    }

    public static final String calculateLink(String link, String relativePath) {
        if (link == null) {
            link = "io.quarkus.launcher.shaded.";
        }
        if (relativePath == null) {
            relativePath = "io.quarkus.launcher.shaded.";
        }
        if (link.startsWith("io/quarkus/launcher/shaded//site/")) {
            return link.substring(5);
        }
        if (link.startsWith("io/quarkus/launcher/shaded//absolute/")) {
            return link.substring(10);
        }
        if (link.contains("io.quarkus.launcher.shaded.:")) {
            return link;
        }
        if (StringUtils.equals(relativePath, "io.quarkus.launcher.shaded..")) {
            if (link.startsWith("io/quarkus/launcher/shaded//")) {
                return link.substring(1);
            }
            return link;
        }
        if (relativePath.endsWith("io/quarkus/launcher/shaded//") && link.startsWith("io/quarkus/launcher/shaded//")) {
            return relativePath + "io.quarkus.launcher.shaded.." + link.substring(1);
        }
        if (relativePath.endsWith("io/quarkus/launcher/shaded//") || link.startsWith("io/quarkus/launcher/shaded//")) {
            return relativePath + link;
        }
        return relativePath + "io/quarkus/launcher/shaded//" + link;
    }

    public static final String getRelativeWebPath(String oldPath, String newPath) {
        if (StringUtils.isEmpty(oldPath) || StringUtils.isEmpty(newPath)) {
            return "io.quarkus.launcher.shaded.";
        }
        String resultPath = PathTool.buildRelativePath(newPath, oldPath, '/');
        if (newPath.endsWith("io/quarkus/launcher/shaded//") && !resultPath.endsWith("io/quarkus/launcher/shaded//")) {
            return resultPath + "io/quarkus/launcher/shaded//";
        }
        return resultPath;
    }

    public static final String getRelativeFilePath(String oldPath, String newPath) {
        if (StringUtils.isEmpty(oldPath) || StringUtils.isEmpty(newPath)) {
            return "io.quarkus.launcher.shaded.";
        }
        String fromPath = new File(oldPath).getPath();
        String toPath = new File(newPath).getPath();
        if (toPath.matches("io.quarkus.launcher.shaded.^\\[a-zA-Z]:")) {
            toPath = toPath.substring(1);
        }
        if (fromPath.matches("io.quarkus.launcher.shaded.^\\[a-zA-Z]:")) {
            fromPath = fromPath.substring(1);
        }
        if (fromPath.startsWith("io.quarkus.launcher.shaded.:", 1)) {
            fromPath = Character.toLowerCase(fromPath.charAt(0)) + fromPath.substring(1);
        }
        if (toPath.startsWith("io.quarkus.launcher.shaded.:", 1)) {
            toPath = Character.toLowerCase(toPath.charAt(0)) + toPath.substring(1);
        }
        if (toPath.startsWith("io.quarkus.launcher.shaded.:", 1) && fromPath.startsWith("io.quarkus.launcher.shaded.:", 1) && !toPath.substring(0, 1).equals(fromPath.substring(0, 1))) {
            return null;
        }
        if (toPath.startsWith("io.quarkus.launcher.shaded.:", 1) && !fromPath.startsWith("io.quarkus.launcher.shaded.:", 1) || !toPath.startsWith("io.quarkus.launcher.shaded.:", 1) && fromPath.startsWith("io.quarkus.launcher.shaded.:", 1)) {
            return null;
        }
        String resultPath = PathTool.buildRelativePath(toPath, fromPath, File.separatorChar);
        if (newPath.endsWith(File.separator) && !resultPath.endsWith(File.separator)) {
            return resultPath + File.separator;
        }
        return resultPath;
    }

    private static final String determineRelativePath(String filename, String separator) {
        if (filename.length() == 0) {
            return "io.quarkus.launcher.shaded.";
        }
        int slashCount = StringUtils.countMatches(filename, separator) - 1;
        if (slashCount <= 0) {
            return "io.quarkus.launcher.shaded..";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < slashCount; ++i) {
            sb.append("io/quarkus/launcher/shaded/../");
        }
        return StringUtils.chop(sb.toString());
    }

    private static final String determineSeparator(String filename) {
        int backwardCount;
        int forwardCount = StringUtils.countMatches(filename, "io/quarkus/launcher/shaded//");
        return forwardCount >= (backwardCount = StringUtils.countMatches(filename, "io.quarkus.launcher.shaded.\\")) ? "io/quarkus/launcher/shaded//" : "io.quarkus.launcher.shaded.\\";
    }

    static final String uppercaseDrive(String path) {
        if (path == null) {
            return null;
        }
        if (path.length() >= 2 && path.charAt(1) == ':') {
            path = Character.toUpperCase(path.charAt(0)) + path.substring(1);
        }
        return path;
    }

    private static final String buildRelativePath(String toPath, String fromPath, char separatorChar) {
        StringTokenizer toTokeniser = new StringTokenizer(toPath, String.valueOf(separatorChar));
        StringTokenizer fromTokeniser = new StringTokenizer(fromPath, String.valueOf(separatorChar));
        int count = 0;
        while (toTokeniser.hasMoreTokens() && fromTokeniser.hasMoreTokens() && !(separatorChar == '\\' ? !fromTokeniser.nextToken().equalsIgnoreCase(toTokeniser.nextToken()) : !fromTokeniser.nextToken().equals(toTokeniser.nextToken()))) {
            ++count;
        }
        toTokeniser = new StringTokenizer(toPath, String.valueOf(separatorChar));
        fromTokeniser = new StringTokenizer(fromPath, String.valueOf(separatorChar));
        while (count-- > 0) {
            fromTokeniser.nextToken();
            toTokeniser.nextToken();
        }
        String relativePath = "io.quarkus.launcher.shaded.";
        while (fromTokeniser.hasMoreTokens()) {
            fromTokeniser.nextToken();
            relativePath = relativePath + "io.quarkus.launcher.shaded...";
            if (!fromTokeniser.hasMoreTokens()) continue;
            relativePath = relativePath + separatorChar;
        }
        if (relativePath.length() != 0 && toTokeniser.hasMoreTokens()) {
            relativePath = relativePath + separatorChar;
        }
        while (toTokeniser.hasMoreTokens()) {
            relativePath = relativePath + toTokeniser.nextToken();
            if (!toTokeniser.hasMoreTokens()) continue;
            relativePath = relativePath + separatorChar;
        }
        return relativePath;
    }
}

