/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.codehaus.plexus.util.cli.shell;

import io.quarkus.launcher.shaded.org.codehaus.plexus.util.Os;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.cli.shell.Shell;
import java.util.ArrayList;
import java.util.List;

public class BourneShell
extends Shell {
    public BourneShell() {
        this(false);
    }

    public BourneShell(boolean isLoginShell) {
        this.setUnconditionalQuoting(true);
        this.setShellCommand("io/quarkus/launcher/shaded//bin/sh");
        this.setArgumentQuoteDelimiter('\'');
        this.setExecutableQuoteDelimiter('\'');
        this.setSingleQuotedArgumentEscaped(true);
        this.setSingleQuotedExecutableEscaped(false);
        this.setQuotedExecutableEnabled(true);
        this.setArgumentEscapePattern("io.quarkus.launcher.shaded.'\\%s'");
        if (isLoginShell) {
            this.addShellArg("io.quarkus.launcher.shaded.-l");
        }
    }

    @Override
    public String getExecutable() {
        if (Os.isFamily("io.quarkus.launcher.shaded.windows")) {
            return super.getExecutable();
        }
        return this.quoteOneItem(super.getOriginalExecutable(), true);
    }

    @Override
    public List<String> getShellArgsList() {
        ArrayList<String> shellArgs = new ArrayList<String>();
        List<String> existingShellArgs = super.getShellArgsList();
        if (existingShellArgs != null && !existingShellArgs.isEmpty()) {
            shellArgs.addAll(existingShellArgs);
        }
        shellArgs.add("io.quarkus.launcher.shaded.-c");
        return shellArgs;
    }

    @Override
    public String[] getShellArgs() {
        String[] shellArgs = super.getShellArgs();
        if (shellArgs == null) {
            shellArgs = new String[]{};
        }
        if (shellArgs.length > 0 && !shellArgs[shellArgs.length - 1].equals("io.quarkus.launcher.shaded.-c")) {
            String[] newArgs = new String[shellArgs.length + 1];
            System.arraycopy(shellArgs, 0, newArgs, 0, shellArgs.length);
            newArgs[shellArgs.length] = "io.quarkus.launcher.shaded.-c";
            shellArgs = newArgs;
        }
        return shellArgs;
    }

    @Override
    protected String getExecutionPreamble() {
        if (this.getWorkingDirectoryAsString() == null) {
            return null;
        }
        String dir = this.getWorkingDirectoryAsString();
        StringBuilder sb = new StringBuilder();
        sb.append("io.quarkus.launcher.shaded.cd ");
        sb.append(this.quoteOneItem(dir, false));
        sb.append("io.quarkus.launcher.shaded. && ");
        return sb.toString();
    }

    @Override
    protected String quoteOneItem(String path, boolean isExecutable) {
        if (path == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("io.quarkus.launcher.shaded.'");
        sb.append(path.replace("io.quarkus.launcher.shaded.'", "io.quarkus.launcher.shaded.'\"'\"'"));
        sb.append("io.quarkus.launcher.shaded.'");
        return sb.toString();
    }
}

