/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.artifact;

import io.quarkus.launcher.shaded.org.eclipse.aether.artifact.AbstractArtifact;
import io.quarkus.launcher.shaded.org.eclipse.aether.artifact.ArtifactType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class DefaultArtifactType
implements ArtifactType {
    private final String id;
    private final String extension;
    private final String classifier;
    private final Map<String, String> properties;

    public DefaultArtifactType(String id) {
        this(id, id, "io.quarkus.launcher.shaded.", "io.quarkus.launcher.shaded.none", false, false);
    }

    public DefaultArtifactType(String id, String extension, String classifier, String language) {
        this(id, extension, classifier, language, true, false);
    }

    public DefaultArtifactType(String id, String extension, String classifier, String language, boolean constitutesBuildPath, boolean includesDependencies) {
        this.id = Objects.requireNonNull(id, "io.quarkus.launcher.shaded.type id cannot be null");
        if (id.length() == 0) {
            throw new IllegalArgumentException("io.quarkus.launcher.shaded.type id cannot be empty");
        }
        this.extension = DefaultArtifactType.emptify(extension);
        this.classifier = DefaultArtifactType.emptify(classifier);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("io.quarkus.launcher.shaded.type", id);
        props.put("io.quarkus.launcher.shaded.language", language != null && language.length() > 0 ? language : "io.quarkus.launcher.shaded.none");
        props.put("io.quarkus.launcher.shaded.includesDependencies", Boolean.toString(includesDependencies));
        props.put("io.quarkus.launcher.shaded.constitutesBuildPath", Boolean.toString(constitutesBuildPath));
        this.properties = Collections.unmodifiableMap(props);
    }

    public DefaultArtifactType(String id, String extension, String classifier, Map<String, String> properties) {
        this.id = Objects.requireNonNull(id, "io.quarkus.launcher.shaded.type id cannot be null");
        if (id.length() == 0) {
            throw new IllegalArgumentException("io.quarkus.launcher.shaded.type id cannot be empty");
        }
        this.extension = DefaultArtifactType.emptify(extension);
        this.classifier = DefaultArtifactType.emptify(classifier);
        this.properties = AbstractArtifact.copyProperties(properties);
    }

    private static String emptify(String str) {
        return str == null ? "io.quarkus.launcher.shaded." : str;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }
}

