/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.collection;

import io.quarkus.launcher.shaded.org.eclipse.aether.RepositoryException;
import io.quarkus.launcher.shaded.org.eclipse.aether.collection.CollectRequest;
import io.quarkus.launcher.shaded.org.eclipse.aether.collection.CollectResult;

public class DependencyCollectionException
extends RepositoryException {
    private final transient CollectResult result;

    public DependencyCollectionException(CollectResult result) {
        super("io.quarkus.launcher.shaded.Failed to collect dependencies for " + DependencyCollectionException.getSource(result), DependencyCollectionException.getCause(result));
        this.result = result;
    }

    public DependencyCollectionException(CollectResult result, String message) {
        super(message, DependencyCollectionException.getCause(result));
        this.result = result;
    }

    public DependencyCollectionException(CollectResult result, String message, Throwable cause) {
        super(message, cause);
        this.result = result;
    }

    public CollectResult getResult() {
        return this.result;
    }

    private static String getSource(CollectResult result) {
        if (result == null) {
            return "io.quarkus.launcher.shaded.";
        }
        CollectRequest request = result.getRequest();
        if (request.getRoot() != null) {
            return request.getRoot().toString();
        }
        if (request.getRootArtifact() != null) {
            return request.getRootArtifact().toString();
        }
        return request.getDependencies().toString();
    }

    private static Throwable getCause(CollectResult result) {
        Throwable cause = null;
        if (result != null && !result.getExceptions().isEmpty()) {
            cause = result.getExceptions().get(0);
        }
        return cause;
    }
}

