/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.connector.basic;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.connector.basic.BasicRepositoryConnector;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.RepositoryConnector;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.transport.TransporterProvider;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.io.FileProcessor;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.locator.Service;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.locator.ServiceLocator;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.NoRepositoryConnectorException;
import java.util.Objects;

@Named(value="io.quarkus.launcher.shaded.basic")
public final class BasicRepositoryConnectorFactory
implements RepositoryConnectorFactory,
Service {
    private TransporterProvider transporterProvider;
    private RepositoryLayoutProvider layoutProvider;
    private ChecksumPolicyProvider checksumPolicyProvider;
    private FileProcessor fileProcessor;
    private float priority;

    public BasicRepositoryConnectorFactory() {
    }

    @Inject
    BasicRepositoryConnectorFactory(TransporterProvider transporterProvider, RepositoryLayoutProvider layoutProvider, ChecksumPolicyProvider checksumPolicyProvider, FileProcessor fileProcessor) {
        this.setTransporterProvider(transporterProvider);
        this.setRepositoryLayoutProvider(layoutProvider);
        this.setChecksumPolicyProvider(checksumPolicyProvider);
        this.setFileProcessor(fileProcessor);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setTransporterProvider(locator.getService(TransporterProvider.class));
        this.setRepositoryLayoutProvider(locator.getService(RepositoryLayoutProvider.class));
        this.setChecksumPolicyProvider(locator.getService(ChecksumPolicyProvider.class));
        this.setFileProcessor(locator.getService(FileProcessor.class));
    }

    public BasicRepositoryConnectorFactory setTransporterProvider(TransporterProvider transporterProvider) {
        this.transporterProvider = Objects.requireNonNull(transporterProvider, "io.quarkus.launcher.shaded.transporter provider cannot be null");
        return this;
    }

    public BasicRepositoryConnectorFactory setRepositoryLayoutProvider(RepositoryLayoutProvider layoutProvider) {
        this.layoutProvider = Objects.requireNonNull(layoutProvider, "io.quarkus.launcher.shaded.repository layout provider cannot be null");
        return this;
    }

    public BasicRepositoryConnectorFactory setChecksumPolicyProvider(ChecksumPolicyProvider checksumPolicyProvider) {
        this.checksumPolicyProvider = Objects.requireNonNull(checksumPolicyProvider, "io.quarkus.launcher.shaded.checksum policy provider cannot be null");
        return this;
    }

    public BasicRepositoryConnectorFactory setFileProcessor(FileProcessor fileProcessor) {
        this.fileProcessor = Objects.requireNonNull(fileProcessor, "io.quarkus.launcher.shaded.file processor cannot be null");
        return this;
    }

    @Override
    public float getPriority() {
        return this.priority;
    }

    public BasicRepositoryConnectorFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public RepositoryConnector newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException {
        return new BasicRepositoryConnector(session, repository, this.transporterProvider, this.layoutProvider, this.checksumPolicyProvider, this.fileProcessor);
    }
}

