/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.connector.basic;

import io.quarkus.launcher.shaded.org.slf4j.Logger;
import io.quarkus.launcher.shaded.org.slf4j.LoggerFactory;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

final class PartialFile
implements Closeable {
    static final String EXT_PART = "io.quarkus.launcher.shaded..part";
    static final String EXT_LOCK = "io.quarkus.launcher.shaded..lock";
    private final File partFile;
    private final LockFile lockFile;
    private final long threshold;
    private static final Logger LOGGER = LoggerFactory.getLogger(PartialFile.class);

    private PartialFile(File partFile) {
        this(partFile, null, 0L);
    }

    private PartialFile(File partFile, LockFile lockFile, long threshold) {
        this.partFile = partFile;
        this.lockFile = lockFile;
        this.threshold = threshold;
    }

    public File getFile() {
        return this.partFile;
    }

    public boolean isResume() {
        return this.lockFile != null && this.partFile.length() >= this.threshold;
    }

    @Override
    public void close() throws IOException {
        if (this.partFile.exists() && !this.isResume() && !this.partFile.delete() && this.partFile.exists()) {
            LOGGER.debug("io.quarkus.launcher.shaded.Could not delete temporary file {}", (Object)this.partFile);
        }
        if (this.lockFile != null) {
            this.lockFile.close();
        }
    }

    public String toString() {
        return String.valueOf(this.getFile());
    }

    static class Factory {
        private final boolean resume;
        private final long resumeThreshold;
        private final int requestTimeout;
        private static final Logger LOGGER = LoggerFactory.getLogger(Factory.class);

        Factory(boolean resume, long resumeThreshold, int requestTimeout) {
            this.resume = resume;
            this.resumeThreshold = resumeThreshold;
            this.requestTimeout = requestTimeout;
        }

        public PartialFile newInstance(File dstFile, RemoteAccessChecker checker) throws Exception {
            if (this.resume) {
                File partFile = new File(dstFile.getPath() + PartialFile.EXT_PART);
                long reqTimestamp = System.currentTimeMillis();
                LockFile lockFile = new LockFile(partFile, this.requestTimeout, checker);
                if (lockFile.isConcurrent() && dstFile.lastModified() >= reqTimestamp - 100L) {
                    lockFile.close();
                    return null;
                }
                try {
                    if (!partFile.createNewFile() && !partFile.isFile()) {
                        throw new IOException(partFile.exists() ? "io.quarkus.launcher.shaded.Path exists but is not a file" : "io.quarkus.launcher.shaded.Unknown error");
                    }
                    return new PartialFile(partFile, lockFile, this.resumeThreshold);
                }
                catch (IOException e) {
                    lockFile.close();
                    LOGGER.debug("io.quarkus.launcher.shaded.Cannot create resumable file {}: {}", partFile.getAbsolutePath(), e.getMessage(), e);
                }
            }
            File tempFile = File.createTempFile(dstFile.getName() + '-' + UUID.randomUUID().toString().replace("io.quarkus.launcher.shaded.-", "io.quarkus.launcher.shaded."), "io.quarkus.launcher.shaded..tmp", dstFile.getParentFile());
            return new PartialFile(tempFile);
        }
    }

    static class LockFile {
        private final File lockFile;
        private final FileLock lock;
        private final AtomicBoolean concurrent;

        LockFile(File partFile, int requestTimeout, RemoteAccessChecker checker) throws Exception {
            this.lockFile = new File(partFile.getPath() + PartialFile.EXT_LOCK);
            this.concurrent = new AtomicBoolean(false);
            this.lock = LockFile.lock(this.lockFile, partFile, requestTimeout, checker, this.concurrent);
        }

        private static FileLock lock(File lockFile, File partFile, int requestTimeout, RemoteAccessChecker checker, AtomicBoolean concurrent) throws Exception {
            boolean interrupted = false;
            try {
                long lastLength = -1L;
                long lastTime = 0L;
                while (true) {
                    FileLock lock;
                    if ((lock = LockFile.tryLock(lockFile)) != null) {
                        FileLock fileLock = lock;
                        return fileLock;
                    }
                    long currentLength = partFile.length();
                    long currentTime = System.currentTimeMillis();
                    if (currentLength != lastLength) {
                        if (lastLength < 0L) {
                            concurrent.set(true);
                            checker.checkRemoteAccess();
                            LOGGER.debug("io.quarkus.launcher.shaded.Concurrent download of {} in progress, awaiting completion", (Object)partFile);
                        }
                        lastLength = currentLength;
                        lastTime = currentTime;
                    } else if (requestTimeout > 0 && currentTime - lastTime > (long)Math.max(requestTimeout, 3000)) {
                        throw new IOException("io.quarkus.launcher.shaded.Timeout while waiting for concurrent download of " + partFile + "io.quarkus.launcher.shaded. to progress");
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private static FileLock tryLock(File lockFile) throws IOException {
            RandomAccessFile raf = null;
            FileLock lock = null;
            try {
                raf = new RandomAccessFile(lockFile, "io.quarkus.launcher.shaded.rw");
                lock = raf.getChannel().tryLock(0L, 1L, false);
                if (lock == null) {
                    raf.close();
                    raf = null;
                }
            }
            catch (OverlappingFileLockException e) {
                LockFile.close(raf);
                raf = null;
                lock = null;
            }
            catch (IOException | RuntimeException e) {
                LockFile.close(raf);
                raf = null;
                if (!lockFile.delete()) {
                    lockFile.deleteOnExit();
                }
                throw e;
            }
            finally {
                try {
                    if (lock == null && raf != null) {
                        raf.close();
                    }
                }
                catch (IOException e) {}
            }
            return lock;
        }

        private static void close(Closeable file) {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public boolean isConcurrent() {
            return this.concurrent.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            FileChannel channel = null;
            try {
                channel = this.lock.channel();
                this.lock.release();
                channel.close();
                channel = null;
            }
            finally {
                try {
                    if (channel != null) {
                        channel.close();
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    if (!this.lockFile.delete()) {
                        this.lockFile.deleteOnExit();
                    }
                }
            }
        }

        public String toString() {
            return this.lockFile + "io.quarkus.launcher.shaded. - " + this.lock.isValid();
        }
    }

    static interface RemoteAccessChecker {
        public void checkRemoteAccess() throws Exception;
    }
}

