/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.installation;

import io.quarkus.launcher.shaded.org.eclipse.aether.artifact.Artifact;
import io.quarkus.launcher.shaded.org.eclipse.aether.installation.InstallRequest;
import io.quarkus.launcher.shaded.org.eclipse.aether.metadata.Metadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public final class InstallResult {
    private final InstallRequest request;
    private Collection<Artifact> artifacts;
    private Collection<Metadata> metadata;

    public InstallResult(InstallRequest request) {
        this.request = Objects.requireNonNull(request, "io.quarkus.launcher.shaded.install request cannot be null");
        this.artifacts = Collections.emptyList();
        this.metadata = Collections.emptyList();
    }

    public InstallRequest getRequest() {
        return this.request;
    }

    public Collection<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public InstallResult setArtifacts(Collection<Artifact> artifacts) {
        this.artifacts = artifacts == null ? Collections.emptyList() : artifacts;
        return this;
    }

    public InstallResult addArtifact(Artifact artifact) {
        if (artifact != null) {
            if (this.artifacts.isEmpty()) {
                this.artifacts = new ArrayList<Artifact>();
            }
            this.artifacts.add(artifact);
        }
        return this;
    }

    public Collection<Metadata> getMetadata() {
        return this.metadata;
    }

    public InstallResult setMetadata(Collection<Metadata> metadata) {
        this.metadata = metadata == null ? Collections.emptyList() : metadata;
        return this;
    }

    public InstallResult addMetadata(Metadata metadata) {
        if (metadata != null) {
            if (this.metadata.isEmpty()) {
                this.metadata = new ArrayList<Metadata>();
            }
            this.metadata.add(metadata);
        }
        return this;
    }

    public String toString() {
        return this.getArtifacts() + "io.quarkus.launcher.shaded., " + this.getMetadata();
    }
}

