/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl;

import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.checksum.ChecksumPolicy;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.ChecksumFailureException;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.TransferResource;
import io.quarkus.launcher.shaded.org.slf4j.Logger;
import io.quarkus.launcher.shaded.org.slf4j.LoggerFactory;

abstract class AbstractChecksumPolicy
implements ChecksumPolicy {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final TransferResource resource;

    protected AbstractChecksumPolicy(TransferResource resource) {
        this.resource = resource;
    }

    @Override
    public boolean onChecksumMatch(String algorithm, int kind) {
        return true;
    }

    @Override
    public void onChecksumMismatch(String algorithm, int kind, ChecksumFailureException exception) throws ChecksumFailureException {
        if ((kind & 1) == 0) {
            throw exception;
        }
    }

    @Override
    public void onChecksumError(String algorithm, int kind, ChecksumFailureException exception) throws ChecksumFailureException {
        this.logger.debug("io.quarkus.launcher.shaded.Could not validate {} checksum for {}", algorithm, this.resource.getResourceName(), exception);
    }

    @Override
    public void onNoMoreChecksums() throws ChecksumFailureException {
        throw new ChecksumFailureException("io.quarkus.launcher.shaded.Checksum validation failed, no checksums available");
    }

    @Override
    public void onTransferRetry() {
    }
}

