/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl;

import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl.FailChecksumPolicy;
import io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl.WarnChecksumPolicy;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.checksum.ChecksumPolicy;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.TransferResource;

@Named
public final class DefaultChecksumPolicyProvider
implements ChecksumPolicyProvider {
    private static final int ORDINAL_IGNORE = 0;
    private static final int ORDINAL_WARN = 1;
    private static final int ORDINAL_FAIL = 2;

    @Override
    public ChecksumPolicy newChecksumPolicy(RepositorySystemSession session, RemoteRepository repository, TransferResource resource, String policy) {
        if ("io.quarkus.launcher.shaded.ignore".equals(policy)) {
            return null;
        }
        if ("io.quarkus.launcher.shaded.fail".equals(policy)) {
            return new FailChecksumPolicy(resource);
        }
        return new WarnChecksumPolicy(resource);
    }

    @Override
    public String getEffectiveChecksumPolicy(RepositorySystemSession session, String policy1, String policy2) {
        if (policy1 != null && policy1.equals(policy2)) {
            return policy1;
        }
        int ordinal1 = DefaultChecksumPolicyProvider.ordinalOfPolicy(policy1);
        int ordinal2 = DefaultChecksumPolicyProvider.ordinalOfPolicy(policy2);
        if (ordinal2 < ordinal1) {
            return ordinal2 != 1 ? policy2 : "io.quarkus.launcher.shaded.warn";
        }
        return ordinal1 != 1 ? policy1 : "io.quarkus.launcher.shaded.warn";
    }

    private static int ordinalOfPolicy(String policy) {
        if ("io.quarkus.launcher.shaded.fail".equals(policy)) {
            return 2;
        }
        if ("io.quarkus.launcher.shaded.ignore".equals(policy)) {
            return 0;
        }
        return 1;
    }
}

