/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositoryEvent;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositoryException;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.RequestTrace;
import io.quarkus.launcher.shaded.org.eclipse.aether.SyncContext;
import io.quarkus.launcher.shaded.org.eclipse.aether.artifact.Artifact;
import io.quarkus.launcher.shaded.org.eclipse.aether.deployment.DeployRequest;
import io.quarkus.launcher.shaded.org.eclipse.aether.deployment.DeployResult;
import io.quarkus.launcher.shaded.org.eclipse.aether.deployment.DeploymentException;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.Deployer;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.MetadataGenerator;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.MetadataGeneratorFactory;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.OfflineController;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.RemoteRepositoryManager;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.RepositoryConnectorProvider;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.RepositoryEventDispatcher;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.SyncContextFactory;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.UpdateCheck;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.UpdateCheckManager;
import io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl.PrioritizedComponent;
import io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl.PrioritizedComponents;
import io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl.SafeTransferListener;
import io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl.Utils;
import io.quarkus.launcher.shaded.org.eclipse.aether.metadata.MergeableMetadata;
import io.quarkus.launcher.shaded.org.eclipse.aether.metadata.Metadata;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalRepositoryManager;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RepositoryPolicy;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.ArtifactUpload;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.MetadataDownload;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.MetadataUpload;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.RepositoryConnector;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.io.FileProcessor;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.locator.Service;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.locator.ServiceLocator;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.ArtifactTransferException;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.MetadataNotFoundException;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.MetadataTransferException;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.NoRepositoryConnectorException;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.RepositoryOfflineException;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.TransferCancelledException;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.TransferEvent;
import io.quarkus.launcher.shaded.org.eclipse.aether.transform.FileTransformer;
import io.quarkus.launcher.shaded.org.eclipse.aether.transform.FileTransformerManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Named
public class DefaultDeployer
implements Deployer,
Service {
    private FileProcessor fileProcessor;
    private RepositoryEventDispatcher repositoryEventDispatcher;
    private RepositoryConnectorProvider repositoryConnectorProvider;
    private RemoteRepositoryManager remoteRepositoryManager;
    private UpdateCheckManager updateCheckManager;
    private Collection<MetadataGeneratorFactory> metadataFactories = new ArrayList<MetadataGeneratorFactory>();
    private SyncContextFactory syncContextFactory;
    private OfflineController offlineController;

    public DefaultDeployer() {
    }

    @Inject
    DefaultDeployer(FileProcessor fileProcessor, RepositoryEventDispatcher repositoryEventDispatcher, RepositoryConnectorProvider repositoryConnectorProvider, RemoteRepositoryManager remoteRepositoryManager, UpdateCheckManager updateCheckManager, Set<MetadataGeneratorFactory> metadataFactories, SyncContextFactory syncContextFactory, OfflineController offlineController) {
        this.setFileProcessor(fileProcessor);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
        this.setRepositoryConnectorProvider(repositoryConnectorProvider);
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setUpdateCheckManager(updateCheckManager);
        this.setMetadataGeneratorFactories(metadataFactories);
        this.setSyncContextFactory(syncContextFactory);
        this.setOfflineController(offlineController);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setFileProcessor(locator.getService(FileProcessor.class));
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
        this.setRepositoryConnectorProvider(locator.getService(RepositoryConnectorProvider.class));
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setUpdateCheckManager(locator.getService(UpdateCheckManager.class));
        this.setMetadataGeneratorFactories(locator.getServices(MetadataGeneratorFactory.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
        this.setOfflineController(locator.getService(OfflineController.class));
    }

    public DefaultDeployer setFileProcessor(FileProcessor fileProcessor) {
        this.fileProcessor = Objects.requireNonNull(fileProcessor, "io.quarkus.launcher.shaded.file processor cannot be null");
        return this;
    }

    public DefaultDeployer setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "io.quarkus.launcher.shaded.repository event dispatcher cannot be null");
        return this;
    }

    public DefaultDeployer setRepositoryConnectorProvider(RepositoryConnectorProvider repositoryConnectorProvider) {
        this.repositoryConnectorProvider = Objects.requireNonNull(repositoryConnectorProvider, "io.quarkus.launcher.shaded.repository connector provider cannot be null");
        return this;
    }

    public DefaultDeployer setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "io.quarkus.launcher.shaded.remote repository provider cannot be null");
        return this;
    }

    public DefaultDeployer setUpdateCheckManager(UpdateCheckManager updateCheckManager) {
        this.updateCheckManager = Objects.requireNonNull(updateCheckManager, "io.quarkus.launcher.shaded.update check manager cannot be null");
        return this;
    }

    public DefaultDeployer addMetadataGeneratorFactory(MetadataGeneratorFactory factory) {
        this.metadataFactories.add(Objects.requireNonNull(factory, "io.quarkus.launcher.shaded.metadata generator factory cannot be null"));
        return this;
    }

    public DefaultDeployer setMetadataGeneratorFactories(Collection<MetadataGeneratorFactory> metadataFactories) {
        this.metadataFactories = metadataFactories == null ? new ArrayList<MetadataGeneratorFactory>() : metadataFactories;
        return this;
    }

    public DefaultDeployer setSyncContextFactory(SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "io.quarkus.launcher.shaded.sync context factory cannot be null");
        return this;
    }

    public DefaultDeployer setOfflineController(OfflineController offlineController) {
        this.offlineController = Objects.requireNonNull(offlineController, "io.quarkus.launcher.shaded.offline controller cannot be null");
        return this;
    }

    @Override
    public DeployResult deploy(RepositorySystemSession session, DeployRequest request) throws DeploymentException {
        try {
            Utils.checkOffline(session, this.offlineController, request.getRepository());
        }
        catch (RepositoryOfflineException e) {
            throw new DeploymentException("io.quarkus.launcher.shaded.Cannot deploy while " + request.getRepository().getId() + "io.quarkus.launcher.shaded. (" + request.getRepository().getUrl() + "io.quarkus.launcher.shaded.) is in offline mode", e);
        }
        try (SyncContext syncContext = this.syncContextFactory.newInstance(session, false);){
            DeployResult deployResult = this.deploy(syncContext, session, request);
            return deployResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private DeployResult deploy(SyncContext syncContext, RepositorySystemSession session, DeployRequest request) throws DeploymentException {
        RepositoryConnector connector;
        DeployResult result = new DeployResult(request);
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        RemoteRepository repository = request.getRepository();
        try {
            connector = this.repositoryConnectorProvider.newRepositoryConnector(session, repository);
        }
        catch (NoRepositoryConnectorException e) {
            throw new DeploymentException("io/quarkus/launcher/shaded/Failed to deploy artifacts/metadata: " + e.getMessage(), e);
        }
        try {
            List<? extends MetadataGenerator> generators = this.getMetadataGenerators(session, request);
            FileTransformerManager fileTransformerManager = session.getFileTransformerManager();
            ArrayList<ArtifactUpload> artifactUploads = new ArrayList<ArtifactUpload>();
            ArrayList<MetadataUpload> metadataUploads = new ArrayList<MetadataUpload>();
            IdentityHashMap processedMetadata = new IdentityHashMap();
            EventCatapult catapult = new EventCatapult(session, trace, repository, this.repositoryEventDispatcher);
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>(request.getArtifacts());
            List<Metadata> metadatas = Utils.prepareMetadata(generators, artifacts);
            syncContext.acquire(artifacts, Utils.combine(request.getMetadata(), metadatas));
            for (Metadata metadata : metadatas) {
                this.upload(metadataUploads, session, metadata, repository, connector, catapult);
                processedMetadata.put(metadata, null);
            }
            for (int i = 0; i < artifacts.size(); ++i) {
                void var17_23;
                Artifact artifact = (Artifact)artifacts.get(i);
                for (MetadataGenerator metadataGenerator : generators) {
                    Artifact artifact2 = metadataGenerator.transformArtifact((Artifact)var17_23);
                }
                artifacts.set(i, (Artifact)var17_23);
                Collection<FileTransformer> fileTransformers = fileTransformerManager.getTransformersForArtifact((Artifact)var17_23);
                if (!fileTransformers.isEmpty()) {
                    for (FileTransformer fileTransformer : fileTransformers) {
                        Artifact targetArtifact = fileTransformer.transformArtifact((Artifact)var17_23);
                        ArtifactUpload upload = new ArtifactUpload(targetArtifact, var17_23.getFile(), fileTransformer);
                        upload.setTrace(trace);
                        upload.setListener(new ArtifactUploadListener(catapult, upload));
                        artifactUploads.add(upload);
                    }
                    continue;
                }
                ArtifactUpload artifactUpload = new ArtifactUpload((Artifact)var17_23, var17_23.getFile());
                artifactUpload.setTrace(trace);
                artifactUpload.setListener(new ArtifactUploadListener(catapult, artifactUpload));
                artifactUploads.add(artifactUpload);
            }
            connector.put(artifactUploads, null);
            for (ArtifactUpload artifactUpload : artifactUploads) {
                if (artifactUpload.getException() != null) {
                    throw new DeploymentException("io.quarkus.launcher.shaded.Failed to deploy artifacts: " + artifactUpload.getException().getMessage(), artifactUpload.getException());
                }
                result.addArtifact(artifactUpload.getArtifact());
            }
            metadatas = Utils.finishMetadata(generators, artifacts);
            syncContext.acquire(null, metadatas);
            for (Metadata metadata : metadatas) {
                this.upload(metadataUploads, session, metadata, repository, connector, catapult);
                processedMetadata.put(metadata, null);
            }
            for (Metadata metadata : request.getMetadata()) {
                if (processedMetadata.containsKey(metadata)) continue;
                this.upload(metadataUploads, session, metadata, repository, connector, catapult);
                processedMetadata.put(metadata, null);
            }
            connector.put(null, metadataUploads);
            for (MetadataUpload metadataUpload : metadataUploads) {
                if (metadataUpload.getException() != null) {
                    throw new DeploymentException("io.quarkus.launcher.shaded.Failed to deploy metadata: " + metadataUpload.getException().getMessage(), metadataUpload.getException());
                }
                result.addMetadata(metadataUpload.getMetadata());
            }
        }
        finally {
            connector.close();
        }
        return result;
    }

    private List<? extends MetadataGenerator> getMetadataGenerators(RepositorySystemSession session, DeployRequest request) {
        PrioritizedComponents<MetadataGeneratorFactory> factories = Utils.sortMetadataGeneratorFactories(session, this.metadataFactories);
        ArrayList<MetadataGenerator> generators = new ArrayList<MetadataGenerator>();
        for (PrioritizedComponent<MetadataGeneratorFactory> factory : factories.getEnabled()) {
            MetadataGenerator generator = factory.getComponent().newInstance(session, request);
            if (generator == null) continue;
            generators.add(generator);
        }
        return generators;
    }

    private void upload(Collection<MetadataUpload> metadataUploads, RepositorySystemSession session, Metadata metadata, RemoteRepository repository, RepositoryConnector connector, EventCatapult catapult) throws DeploymentException {
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        File basedir = lrm.getRepository().getBasedir();
        File dstFile = new File(basedir, lrm.getPathForRemoteMetadata(metadata, repository, "io.quarkus.launcher.shaded."));
        if (metadata instanceof MergeableMetadata) {
            if (!((MergeableMetadata)metadata).isMerged()) {
                RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_RESOLVING);
                event.setTrace(catapult.getTrace());
                event.setMetadata(metadata);
                event.setRepository(repository);
                this.repositoryEventDispatcher.dispatch(event.build());
                event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_DOWNLOADING);
                event.setTrace(catapult.getTrace());
                event.setMetadata(metadata);
                event.setRepository(repository);
                this.repositoryEventDispatcher.dispatch(event.build());
                RepositoryPolicy policy = this.getPolicy(session, repository, metadata.getNature());
                MetadataDownload download = new MetadataDownload();
                download.setMetadata(metadata);
                download.setFile(dstFile);
                download.setChecksumPolicy(policy.getChecksumPolicy());
                download.setListener(SafeTransferListener.wrap(session));
                download.setTrace(catapult.getTrace());
                connector.get(null, Arrays.asList(download));
                MetadataTransferException error = download.getException();
                if (error instanceof MetadataNotFoundException) {
                    dstFile.delete();
                }
                event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_DOWNLOADED);
                event.setTrace(catapult.getTrace());
                event.setMetadata(metadata);
                event.setRepository(repository);
                event.setException(error);
                event.setFile(dstFile);
                this.repositoryEventDispatcher.dispatch(event.build());
                event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_RESOLVED);
                event.setTrace(catapult.getTrace());
                event.setMetadata(metadata);
                event.setRepository(repository);
                event.setException(error);
                event.setFile(dstFile);
                this.repositoryEventDispatcher.dispatch(event.build());
                if (error != null && !(error instanceof MetadataNotFoundException)) {
                    throw new DeploymentException("io.quarkus.launcher.shaded.Failed to retrieve remote metadata " + metadata + "io.quarkus.launcher.shaded.: " + error.getMessage(), error);
                }
            }
            try {
                ((MergeableMetadata)metadata).merge(dstFile, dstFile);
            }
            catch (RepositoryException e) {
                throw new DeploymentException("io.quarkus.launcher.shaded.Failed to update metadata " + metadata + "io.quarkus.launcher.shaded.: " + e.getMessage(), e);
            }
        }
        if (metadata.getFile() == null) {
            throw new DeploymentException("io.quarkus.launcher.shaded.Failed to update metadata " + metadata + "io.quarkus.launcher.shaded.: No file attached.");
        }
        try {
            this.fileProcessor.copy(metadata.getFile(), dstFile);
        }
        catch (IOException e) {
            throw new DeploymentException("io.quarkus.launcher.shaded.Failed to update metadata " + metadata + "io.quarkus.launcher.shaded.: " + e.getMessage(), e);
        }
        UpdateCheck<Metadata, MetadataTransferException> check = new UpdateCheck<Metadata, MetadataTransferException>();
        check.setItem(metadata);
        check.setFile(dstFile);
        check.setRepository(repository);
        check.setAuthoritativeRepository(repository);
        this.updateCheckManager.touchMetadata(session, check);
        MetadataUpload upload = new MetadataUpload(metadata, dstFile);
        upload.setTrace(catapult.getTrace());
        upload.setListener(new MetadataUploadListener(catapult, upload));
        metadataUploads.add(upload);
    }

    private RepositoryPolicy getPolicy(RepositorySystemSession session, RemoteRepository repository, Metadata.Nature nature) {
        boolean releases = !Metadata.Nature.SNAPSHOT.equals((Object)nature);
        boolean snapshots = !Metadata.Nature.RELEASE.equals((Object)nature);
        return this.remoteRepositoryManager.getPolicy(session, repository, releases, snapshots);
    }

    static final class MetadataUploadListener
    extends SafeTransferListener {
        private final EventCatapult catapult;
        private final MetadataUpload transfer;

        MetadataUploadListener(EventCatapult catapult, MetadataUpload transfer) {
            super(catapult.getSession());
            this.catapult = catapult;
            this.transfer = transfer;
        }

        @Override
        public void transferInitiated(TransferEvent event) throws TransferCancelledException {
            super.transferInitiated(event);
            this.catapult.metadataDeploying(this.transfer.getMetadata(), this.transfer.getFile());
        }

        @Override
        public void transferFailed(TransferEvent event) {
            super.transferFailed(event);
            this.catapult.metadataDeployed(this.transfer.getMetadata(), this.transfer.getFile(), this.transfer.getException());
        }

        @Override
        public void transferSucceeded(TransferEvent event) {
            super.transferSucceeded(event);
            this.catapult.metadataDeployed(this.transfer.getMetadata(), this.transfer.getFile(), null);
        }
    }

    static final class ArtifactUploadListener
    extends SafeTransferListener {
        private final EventCatapult catapult;
        private final ArtifactUpload transfer;

        ArtifactUploadListener(EventCatapult catapult, ArtifactUpload transfer) {
            super(catapult.getSession());
            this.catapult = catapult;
            this.transfer = transfer;
        }

        @Override
        public void transferInitiated(TransferEvent event) throws TransferCancelledException {
            super.transferInitiated(event);
            this.catapult.artifactDeploying(this.transfer.getArtifact(), this.transfer.getFile());
        }

        @Override
        public void transferFailed(TransferEvent event) {
            super.transferFailed(event);
            this.catapult.artifactDeployed(this.transfer.getArtifact(), this.transfer.getFile(), this.transfer.getException());
        }

        @Override
        public void transferSucceeded(TransferEvent event) {
            super.transferSucceeded(event);
            this.catapult.artifactDeployed(this.transfer.getArtifact(), this.transfer.getFile(), null);
        }
    }

    static final class EventCatapult {
        private final RepositorySystemSession session;
        private final RequestTrace trace;
        private final RemoteRepository repository;
        private final RepositoryEventDispatcher dispatcher;

        EventCatapult(RepositorySystemSession session, RequestTrace trace, RemoteRepository repository, RepositoryEventDispatcher dispatcher) {
            this.session = session;
            this.trace = trace;
            this.repository = repository;
            this.dispatcher = dispatcher;
        }

        public RepositorySystemSession getSession() {
            return this.session;
        }

        public RequestTrace getTrace() {
            return this.trace;
        }

        public void artifactDeploying(Artifact artifact, File file) {
            RepositoryEvent.Builder event = new RepositoryEvent.Builder(this.session, RepositoryEvent.EventType.ARTIFACT_DEPLOYING);
            event.setTrace(this.trace);
            event.setArtifact(artifact);
            event.setRepository(this.repository);
            event.setFile(file);
            this.dispatcher.dispatch(event.build());
        }

        public void artifactDeployed(Artifact artifact, File file, ArtifactTransferException exception) {
            RepositoryEvent.Builder event = new RepositoryEvent.Builder(this.session, RepositoryEvent.EventType.ARTIFACT_DEPLOYED);
            event.setTrace(this.trace);
            event.setArtifact(artifact);
            event.setRepository(this.repository);
            event.setFile(file);
            event.setException(exception);
            this.dispatcher.dispatch(event.build());
        }

        public void metadataDeploying(Metadata metadata, File file) {
            RepositoryEvent.Builder event = new RepositoryEvent.Builder(this.session, RepositoryEvent.EventType.METADATA_DEPLOYING);
            event.setTrace(this.trace);
            event.setMetadata(metadata);
            event.setRepository(this.repository);
            event.setFile(file);
            this.dispatcher.dispatch(event.build());
        }

        public void metadataDeployed(Metadata metadata, File file, Exception exception) {
            RepositoryEvent.Builder event = new RepositoryEvent.Builder(this.session, RepositoryEvent.EventType.METADATA_DEPLOYED);
            event.setTrace(this.trace);
            event.setMetadata(metadata);
            event.setRepository(this.repository);
            event.setFile(file);
            event.setException(exception);
            this.dispatcher.dispatch(event.build());
        }
    }
}

