/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.LocalRepositoryProvider;
import io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl.PrioritizedComponent;
import io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl.PrioritizedComponents;
import io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl.Utils;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalRepositoryManager;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.locator.Service;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.locator.ServiceLocator;
import io.quarkus.launcher.shaded.org.slf4j.Logger;
import io.quarkus.launcher.shaded.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

@Named
public class DefaultLocalRepositoryProvider
implements LocalRepositoryProvider,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLocalRepositoryProvider.class);
    private Collection<LocalRepositoryManagerFactory> managerFactories = new ArrayList<LocalRepositoryManagerFactory>();

    public DefaultLocalRepositoryProvider() {
    }

    @Inject
    DefaultLocalRepositoryProvider(Set<LocalRepositoryManagerFactory> factories) {
        this.setLocalRepositoryManagerFactories(factories);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLocalRepositoryManagerFactories(locator.getServices(LocalRepositoryManagerFactory.class));
    }

    public DefaultLocalRepositoryProvider addLocalRepositoryManagerFactory(LocalRepositoryManagerFactory factory) {
        this.managerFactories.add(Objects.requireNonNull(factory, "io.quarkus.launcher.shaded.local repository manager factory cannot be null"));
        return this;
    }

    public DefaultLocalRepositoryProvider setLocalRepositoryManagerFactories(Collection<LocalRepositoryManagerFactory> factories) {
        this.managerFactories = factories == null ? new ArrayList<LocalRepositoryManagerFactory>(2) : factories;
        return this;
    }

    @Override
    public LocalRepositoryManager newLocalRepositoryManager(RepositorySystemSession session, LocalRepository repository) throws NoLocalRepositoryManagerException {
        PrioritizedComponents<LocalRepositoryManagerFactory> factories = new PrioritizedComponents<LocalRepositoryManagerFactory>(session);
        for (LocalRepositoryManagerFactory factory : this.managerFactories) {
            factories.add(factory, factory.getPriority());
        }
        ArrayList<NoLocalRepositoryManagerException> errors = new ArrayList<NoLocalRepositoryManagerException>();
        for (PrioritizedComponent factory : factories.getEnabled()) {
            try {
                LocalRepositoryManager localRepositoryManager = ((LocalRepositoryManagerFactory)factory.getComponent()).newInstance(session, repository);
                if (LOGGER.isDebugEnabled()) {
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("io.quarkus.launcher.shaded.Using manager ").append(localRepositoryManager.getClass().getSimpleName());
                    Utils.appendClassLoader(buffer, localRepositoryManager);
                    buffer.append("io.quarkus.launcher.shaded. with priority ").append(factory.getPriority());
                    buffer.append("io.quarkus.launcher.shaded. for ").append(repository.getBasedir());
                    LOGGER.debug(buffer.toString());
                }
                return localRepositoryManager;
            }
            catch (NoLocalRepositoryManagerException noLocalRepositoryManagerException) {
                errors.add(noLocalRepositoryManagerException);
            }
        }
        if (LOGGER.isDebugEnabled() && errors.size() > 1) {
            String msg = "io.quarkus.launcher.shaded.Could not obtain local repository manager for " + repository;
            for (Exception exception : errors) {
                LOGGER.debug(msg, exception);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("io.quarkus.launcher.shaded.No local repository managers registered");
        } else {
            buffer.append("io.quarkus.launcher.shaded.Cannot access ").append(repository.getBasedir());
            buffer.append("io.quarkus.launcher.shaded. with type ").append(repository.getContentType());
            buffer.append("io.quarkus.launcher.shaded. using the available factories ");
            factories.list(buffer);
        }
        throw new NoLocalRepositoryManagerException(repository, buffer.toString(), errors.size() == 1 ? (NoLocalRepositoryManagerException)errors.get(0) : null);
    }
}

