/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositoryEvent;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.RequestTrace;
import io.quarkus.launcher.shaded.org.eclipse.aether.SyncContext;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.MetadataResolver;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.OfflineController;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.RemoteRepositoryManager;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.RepositoryConnectorProvider;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.RepositoryEventDispatcher;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.SyncContextFactory;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.UpdateCheck;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.UpdateCheckManager;
import io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl.SafeTransferListener;
import io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl.Utils;
import io.quarkus.launcher.shaded.org.eclipse.aether.metadata.Metadata;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.ArtifactRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalMetadataRegistration;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalMetadataRequest;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalMetadataResult;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalRepositoryManager;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RepositoryPolicy;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.MetadataRequest;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.MetadataResult;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.MetadataDownload;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.RepositoryConnector;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.locator.Service;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.locator.ServiceLocator;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.MetadataNotFoundException;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.MetadataTransferException;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.NoRepositoryConnectorException;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.RepositoryOfflineException;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.ConfigUtils;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.concurrency.RunnableErrorForwarder;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.concurrency.WorkerThreadFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Named
public class DefaultMetadataResolver
implements MetadataResolver,
Service {
    private static final String CONFIG_PROP_THREADS = "io.quarkus.launcher.shaded.aether.metadataResolver.threads";
    private RepositoryEventDispatcher repositoryEventDispatcher;
    private UpdateCheckManager updateCheckManager;
    private RepositoryConnectorProvider repositoryConnectorProvider;
    private RemoteRepositoryManager remoteRepositoryManager;
    private SyncContextFactory syncContextFactory;
    private OfflineController offlineController;

    public DefaultMetadataResolver() {
    }

    @Inject
    DefaultMetadataResolver(RepositoryEventDispatcher repositoryEventDispatcher, UpdateCheckManager updateCheckManager, RepositoryConnectorProvider repositoryConnectorProvider, RemoteRepositoryManager remoteRepositoryManager, SyncContextFactory syncContextFactory, OfflineController offlineController) {
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
        this.setUpdateCheckManager(updateCheckManager);
        this.setRepositoryConnectorProvider(repositoryConnectorProvider);
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setSyncContextFactory(syncContextFactory);
        this.setOfflineController(offlineController);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
        this.setUpdateCheckManager(locator.getService(UpdateCheckManager.class));
        this.setRepositoryConnectorProvider(locator.getService(RepositoryConnectorProvider.class));
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
        this.setOfflineController(locator.getService(OfflineController.class));
    }

    public DefaultMetadataResolver setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "io.quarkus.launcher.shaded.repository event dispatcher cannot be null");
        return this;
    }

    public DefaultMetadataResolver setUpdateCheckManager(UpdateCheckManager updateCheckManager) {
        this.updateCheckManager = Objects.requireNonNull(updateCheckManager, "io.quarkus.launcher.shaded.update check manager cannot be null");
        return this;
    }

    public DefaultMetadataResolver setRepositoryConnectorProvider(RepositoryConnectorProvider repositoryConnectorProvider) {
        this.repositoryConnectorProvider = Objects.requireNonNull(repositoryConnectorProvider, "io.quarkus.launcher.shaded.repository connector provider cannot be null");
        return this;
    }

    public DefaultMetadataResolver setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "io.quarkus.launcher.shaded.remote repository provider cannot be null");
        return this;
    }

    public DefaultMetadataResolver setSyncContextFactory(SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "io.quarkus.launcher.shaded.sync context factory cannot be null");
        return this;
    }

    public DefaultMetadataResolver setOfflineController(OfflineController offlineController) {
        this.offlineController = Objects.requireNonNull(offlineController, "io.quarkus.launcher.shaded.offline controller cannot be null");
        return this;
    }

    @Override
    public List<MetadataResult> resolveMetadata(RepositorySystemSession session, Collection<? extends MetadataRequest> requests) {
        try (SyncContext syncContext = this.syncContextFactory.newInstance(session, false);){
            ArrayList<Metadata> metadata = new ArrayList<Metadata>(requests.size());
            for (MetadataRequest metadataRequest : requests) {
                metadata.add(metadataRequest.getMetadata());
            }
            syncContext.acquire(null, metadata);
            List<MetadataResult> list = this.resolve(session, requests);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MetadataResult> resolve(RepositorySystemSession session, Collection<? extends MetadataRequest> requests) {
        Metadata metadata;
        ArrayList<MetadataResult> results = new ArrayList<MetadataResult>(requests.size());
        ArrayList<ResolveTask> tasks = new ArrayList<ResolveTask>(requests.size());
        HashMap<File, Long> localLastUpdates = new HashMap<File, Long>();
        for (MetadataRequest metadataRequest : requests) {
            File localFile;
            RequestTrace trace = RequestTrace.newChild(metadataRequest.getTrace(), metadataRequest);
            MetadataResult result = new MetadataResult(metadataRequest);
            results.add(result);
            metadata = metadataRequest.getMetadata();
            RemoteRepository repository = metadataRequest.getRepository();
            if (repository == null) {
                LocalRepository localRepo = session.getLocalRepositoryManager().getRepository();
                this.metadataResolving(session, trace, metadata, localRepo);
                File localFile2 = this.getLocalFile(session, metadata);
                if (localFile2 != null) {
                    metadata = metadata.setFile(localFile2);
                    result.setMetadata(metadata);
                } else {
                    result.setException(new MetadataNotFoundException(metadata, localRepo));
                }
                this.metadataResolved(session, trace, metadata, localRepo, result.getException());
                continue;
            }
            List<RemoteRepository> repositories = this.getEnabledSourceRepositories(repository, metadata.getNature());
            if (repositories.isEmpty()) continue;
            this.metadataResolving(session, trace, metadata, repository);
            LocalRepositoryManager lrm = session.getLocalRepositoryManager();
            LocalMetadataRequest localRequest = new LocalMetadataRequest(metadata, repository, metadataRequest.getRequestContext());
            LocalMetadataResult lrmResult = lrm.find(session, localRequest);
            File metadataFile = lrmResult.getFile();
            try {
                Utils.checkOffline(session, this.offlineController, repository);
            }
            catch (RepositoryOfflineException e) {
                if (metadataFile != null) {
                    metadata = metadata.setFile(metadataFile);
                    result.setMetadata(metadata);
                } else {
                    String msg = "io.quarkus.launcher.shaded.Cannot access " + repository.getId() + "io.quarkus.launcher.shaded. (" + repository.getUrl() + "io.quarkus.launcher.shaded.) in offline mode and the metadata " + metadata + "io.quarkus.launcher.shaded. has not been downloaded from it before";
                    result.setException(new MetadataNotFoundException(metadata, repository, msg, e));
                }
                this.metadataResolved(session, trace, metadata, repository, result.getException());
                continue;
            }
            Long localLastUpdate = null;
            if (metadataRequest.isFavorLocalRepository() && (localLastUpdate = (Long)localLastUpdates.get(localFile = this.getLocalFile(session, metadata))) == null) {
                localLastUpdate = localFile != null ? localFile.lastModified() : 0L;
                localLastUpdates.put(localFile, localLastUpdate);
            }
            ArrayList<UpdateCheck<Metadata, MetadataTransferException>> checks = new ArrayList<UpdateCheck<Metadata, MetadataTransferException>>();
            MetadataTransferException exception = null;
            for (RemoteRepository repo : repositories) {
                UpdateCheck<Metadata, MetadataTransferException> check = new UpdateCheck<Metadata, MetadataTransferException>();
                check.setLocalLastUpdated(localLastUpdate != null ? localLastUpdate : 0L);
                check.setItem(metadata);
                File checkFile = new File(session.getLocalRepository().getBasedir(), session.getLocalRepositoryManager().getPathForRemoteMetadata(metadata, repository, metadataRequest.getRequestContext()));
                check.setFile(checkFile);
                check.setRepository(repository);
                check.setAuthoritativeRepository(repo);
                check.setPolicy(this.getPolicy(session, repo, metadata.getNature()).getUpdatePolicy());
                if (lrmResult.isStale()) {
                    checks.add(check);
                    continue;
                }
                this.updateCheckManager.checkMetadata(session, check);
                if (check.isRequired()) {
                    checks.add(check);
                    continue;
                }
                if (exception != null) continue;
                exception = check.getException();
            }
            if (!checks.isEmpty()) {
                RepositoryPolicy policy = this.getPolicy(session, repository, metadata.getNature());
                File installFile = new File(session.getLocalRepository().getBasedir(), session.getLocalRepositoryManager().getPathForRemoteMetadata(metadata, metadataRequest.getRepository(), metadataRequest.getRequestContext()));
                ResolveTask task = new ResolveTask(session, trace, result, installFile, checks, policy.getChecksumPolicy());
                tasks.add(task);
                continue;
            }
            result.setException(exception);
            if (metadataFile != null) {
                metadata = metadata.setFile(metadataFile);
                result.setMetadata(metadata);
            }
            this.metadataResolved(session, trace, metadata, repository, result.getException());
        }
        if (!tasks.isEmpty()) {
            int threads = ConfigUtils.getInteger(session, 4, CONFIG_PROP_THREADS);
            Executor executor = this.getExecutor(Math.min(tasks.size(), threads));
            try {
                RunnableErrorForwarder errorForwarder = new RunnableErrorForwarder();
                for (ResolveTask task : tasks) {
                    executor.execute(errorForwarder.wrap(task));
                }
                errorForwarder.await();
                for (ResolveTask task : tasks) {
                    task.result.setException(task.exception);
                }
            }
            finally {
                this.shutdown(executor);
            }
            for (ResolveTask task : tasks) {
                metadata = task.request.getMetadata();
                LocalMetadataRequest localRequest = new LocalMetadataRequest(metadata, task.request.getRepository(), task.request.getRequestContext());
                File metadataFile = session.getLocalRepositoryManager().find(session, localRequest).getFile();
                if (metadataFile != null) {
                    metadata = metadata.setFile(metadataFile);
                    task.result.setMetadata(metadata);
                }
                if (task.result.getException() == null) {
                    task.result.setUpdated(true);
                }
                this.metadataResolved(session, task.trace, metadata, task.request.getRepository(), task.result.getException());
            }
        }
        return results;
    }

    private File getLocalFile(RepositorySystemSession session, Metadata metadata) {
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        LocalMetadataResult localResult = lrm.find(session, new LocalMetadataRequest(metadata, null, null));
        return localResult.getFile();
    }

    private List<RemoteRepository> getEnabledSourceRepositories(RemoteRepository repository, Metadata.Nature nature) {
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
        if (repository.isRepositoryManager()) {
            for (RemoteRepository repo : repository.getMirroredRepositories()) {
                if (!this.isEnabled(repo, nature)) continue;
                repositories.add(repo);
            }
        } else if (this.isEnabled(repository, nature)) {
            repositories.add(repository);
        }
        return repositories;
    }

    private boolean isEnabled(RemoteRepository repository, Metadata.Nature nature) {
        if (!Metadata.Nature.SNAPSHOT.equals((Object)nature) && repository.getPolicy(false).isEnabled()) {
            return true;
        }
        return !Metadata.Nature.RELEASE.equals((Object)nature) && repository.getPolicy(true).isEnabled();
    }

    private RepositoryPolicy getPolicy(RepositorySystemSession session, RemoteRepository repository, Metadata.Nature nature) {
        boolean releases = !Metadata.Nature.SNAPSHOT.equals((Object)nature);
        boolean snapshots = !Metadata.Nature.RELEASE.equals((Object)nature);
        return this.remoteRepositoryManager.getPolicy(session, repository, releases, snapshots);
    }

    private void metadataResolving(RepositorySystemSession session, RequestTrace trace, Metadata metadata, ArtifactRepository repository) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_RESOLVING);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setRepository(repository);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void metadataResolved(RepositorySystemSession session, RequestTrace trace, Metadata metadata, ArtifactRepository repository, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_RESOLVED);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setRepository(repository);
        event.setException(exception);
        event.setFile(metadata.getFile());
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void metadataDownloading(RepositorySystemSession session, RequestTrace trace, Metadata metadata, ArtifactRepository repository) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_DOWNLOADING);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setRepository(repository);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void metadataDownloaded(RepositorySystemSession session, RequestTrace trace, Metadata metadata, ArtifactRepository repository, File file, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_DOWNLOADED);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setRepository(repository);
        event.setException(exception);
        event.setFile(file);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private Executor getExecutor(int threads) {
        if (threads <= 1) {
            return new Executor(){

                @Override
                public void execute(Runnable command) {
                    command.run();
                }
            };
        }
        return new ThreadPoolExecutor(threads, threads, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new WorkerThreadFactory(null));
    }

    private void shutdown(Executor executor) {
        if (executor instanceof ExecutorService) {
            ((ExecutorService)executor).shutdown();
        }
    }

    class ResolveTask
    implements Runnable {
        final RepositorySystemSession session;
        final RequestTrace trace;
        final MetadataResult result;
        final MetadataRequest request;
        final File metadataFile;
        final String policy;
        final List<UpdateCheck<Metadata, MetadataTransferException>> checks;
        volatile MetadataTransferException exception;

        ResolveTask(RepositorySystemSession session, RequestTrace trace, MetadataResult result, File metadataFile, List<UpdateCheck<Metadata, MetadataTransferException>> checks, String policy) {
            this.session = session;
            this.trace = trace;
            this.result = result;
            this.request = result.getRequest();
            this.metadataFile = metadataFile;
            this.policy = policy;
            this.checks = checks;
        }

        @Override
        public void run() {
            Metadata metadata = this.request.getMetadata();
            RemoteRepository requestRepository = this.request.getRepository();
            DefaultMetadataResolver.this.metadataDownloading(this.session, this.trace, metadata, requestRepository);
            try {
                ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
                for (UpdateCheck<Metadata, MetadataTransferException> check : this.checks) {
                    repositories.add(check.getAuthoritativeRepository());
                }
                MetadataDownload download = new MetadataDownload();
                download.setMetadata(metadata);
                download.setRequestContext(this.request.getRequestContext());
                download.setFile(this.metadataFile);
                download.setChecksumPolicy(this.policy);
                download.setRepositories(repositories);
                download.setListener(SafeTransferListener.wrap(this.session));
                download.setTrace(this.trace);
                try (RepositoryConnector connector = DefaultMetadataResolver.this.repositoryConnectorProvider.newRepositoryConnector(this.session, requestRepository);){
                    connector.get(null, Arrays.asList(download));
                }
                this.exception = download.getException();
                if (this.exception == null) {
                    List<String> contexts = Collections.singletonList(this.request.getRequestContext());
                    LocalMetadataRegistration registration = new LocalMetadataRegistration(metadata, requestRepository, contexts);
                    this.session.getLocalRepositoryManager().add(this.session, registration);
                } else if (this.request.isDeleteLocalCopyIfMissing() && this.exception instanceof MetadataNotFoundException) {
                    download.getFile().delete();
                }
            }
            catch (NoRepositoryConnectorException e) {
                this.exception = new MetadataTransferException(metadata, requestRepository, e);
            }
            for (UpdateCheck<Metadata, MetadataTransferException> check : this.checks) {
                DefaultMetadataResolver.this.updateCheckManager.touchMetadata(this.session, check.setException(this.exception));
            }
            DefaultMetadataResolver.this.metadataDownloaded(this.session, this.trace, metadata, requestRepository, this.metadataFile, this.exception);
        }
    }
}

