/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.RepositoryConnectorProvider;
import io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl.PrioritizedComponent;
import io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl.PrioritizedComponents;
import io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl.Utils;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.Authentication;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.Proxy;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.RepositoryConnector;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.locator.Service;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.locator.ServiceLocator;
import io.quarkus.launcher.shaded.org.eclipse.aether.transfer.NoRepositoryConnectorException;
import io.quarkus.launcher.shaded.org.slf4j.Logger;
import io.quarkus.launcher.shaded.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

@Named
public class DefaultRepositoryConnectorProvider
implements RepositoryConnectorProvider,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRepositoryConnectorProvider.class);
    private Collection<RepositoryConnectorFactory> connectorFactories = new ArrayList<RepositoryConnectorFactory>();

    public DefaultRepositoryConnectorProvider() {
    }

    @Inject
    DefaultRepositoryConnectorProvider(Set<RepositoryConnectorFactory> connectorFactories) {
        this.setRepositoryConnectorFactories(connectorFactories);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.connectorFactories = locator.getServices(RepositoryConnectorFactory.class);
    }

    public DefaultRepositoryConnectorProvider addRepositoryConnectorFactory(RepositoryConnectorFactory factory) {
        this.connectorFactories.add(Objects.requireNonNull(factory, "io.quarkus.launcher.shaded.repository connector factory cannot be null"));
        return this;
    }

    public DefaultRepositoryConnectorProvider setRepositoryConnectorFactories(Collection<RepositoryConnectorFactory> factories) {
        this.connectorFactories = factories == null ? new ArrayList<RepositoryConnectorFactory>() : factories;
        return this;
    }

    @Override
    public RepositoryConnector newRepositoryConnector(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException {
        Objects.requireNonNull(repository, "io.quarkus.launcher.shaded.remote repository cannot be null");
        PrioritizedComponents<RepositoryConnectorFactory> factories = new PrioritizedComponents<RepositoryConnectorFactory>(session);
        for (RepositoryConnectorFactory factory : this.connectorFactories) {
            factories.add(factory, factory.getPriority());
        }
        ArrayList<NoRepositoryConnectorException> errors = new ArrayList<NoRepositoryConnectorException>();
        for (PrioritizedComponent factory : factories.getEnabled()) {
            try {
                RepositoryConnector repositoryConnector = ((RepositoryConnectorFactory)factory.getComponent()).newInstance(session, repository);
                if (LOGGER.isDebugEnabled()) {
                    Proxy proxy;
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("io.quarkus.launcher.shaded.Using connector ").append(repositoryConnector.getClass().getSimpleName());
                    Utils.appendClassLoader(buffer, repositoryConnector);
                    buffer.append("io.quarkus.launcher.shaded. with priority ").append(factory.getPriority());
                    buffer.append("io.quarkus.launcher.shaded. for ").append(repository.getUrl());
                    Authentication auth = repository.getAuthentication();
                    if (auth != null) {
                        buffer.append("io.quarkus.launcher.shaded. with ").append(auth);
                    }
                    if ((proxy = repository.getProxy()) != null) {
                        buffer.append("io.quarkus.launcher.shaded. via ").append(proxy.getHost()).append(':').append(proxy.getPort());
                        auth = proxy.getAuthentication();
                        if (auth != null) {
                            buffer.append("io.quarkus.launcher.shaded. with ").append(auth);
                        }
                    }
                    LOGGER.debug(buffer.toString());
                }
                return repositoryConnector;
            }
            catch (NoRepositoryConnectorException noRepositoryConnectorException) {
                errors.add(noRepositoryConnectorException);
            }
        }
        if (LOGGER.isDebugEnabled() && errors.size() > 1) {
            String msg = "io.quarkus.launcher.shaded.Could not obtain connector factory for " + repository;
            for (Exception exception : errors) {
                LOGGER.debug(msg, exception);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("io.quarkus.launcher.shaded.No connector factories available");
        } else {
            buffer.append("io.quarkus.launcher.shaded.Cannot access ").append(repository.getUrl());
            buffer.append("io.quarkus.launcher.shaded. with type ").append(repository.getContentType());
            buffer.append("io.quarkus.launcher.shaded. using the available connector factories: ");
            factories.list(buffer);
        }
        throw new NoRepositoryConnectorException(repository, buffer.toString(), errors.size() == 1 ? (NoRepositoryConnectorException)errors.get(0) : null);
    }
}

