/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl;

import io.quarkus.launcher.shaded.javax.inject.Inject;
import io.quarkus.launcher.shaded.javax.inject.Named;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositoryEvent;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositoryListener;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.RepositoryEventDispatcher;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.locator.Service;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.locator.ServiceLocator;
import io.quarkus.launcher.shaded.org.slf4j.Logger;
import io.quarkus.launcher.shaded.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

@Named
public class DefaultRepositoryEventDispatcher
implements RepositoryEventDispatcher,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRepositoryEventDispatcher.class);
    private Collection<RepositoryListener> listeners = new ArrayList<RepositoryListener>();

    public DefaultRepositoryEventDispatcher() {
    }

    @Inject
    DefaultRepositoryEventDispatcher(Set<RepositoryListener> listeners) {
        this.setRepositoryListeners(listeners);
    }

    public DefaultRepositoryEventDispatcher addRepositoryListener(RepositoryListener listener) {
        this.listeners.add(Objects.requireNonNull(listener, "io.quarkus.launcher.shaded.repository listener cannot be null"));
        return this;
    }

    public DefaultRepositoryEventDispatcher setRepositoryListeners(Collection<RepositoryListener> listeners) {
        this.listeners = listeners == null ? new ArrayList<RepositoryListener>() : listeners;
        return this;
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setRepositoryListeners(locator.getServices(RepositoryListener.class));
    }

    @Override
    public void dispatch(RepositoryEvent event) {
        RepositoryListener listener;
        if (!this.listeners.isEmpty()) {
            for (RepositoryListener listener2 : this.listeners) {
                this.dispatch(event, listener2);
            }
        }
        if ((listener = event.getSession().getRepositoryListener()) != null) {
            this.dispatch(event, listener);
        }
    }

    private void dispatch(RepositoryEvent event, RepositoryListener listener) {
        try {
            switch (event.getType()) {
                case ARTIFACT_DEPLOYED: {
                    listener.artifactDeployed(event);
                    break;
                }
                case ARTIFACT_DEPLOYING: {
                    listener.artifactDeploying(event);
                    break;
                }
                case ARTIFACT_DESCRIPTOR_INVALID: {
                    listener.artifactDescriptorInvalid(event);
                    break;
                }
                case ARTIFACT_DESCRIPTOR_MISSING: {
                    listener.artifactDescriptorMissing(event);
                    break;
                }
                case ARTIFACT_DOWNLOADED: {
                    listener.artifactDownloaded(event);
                    break;
                }
                case ARTIFACT_DOWNLOADING: {
                    listener.artifactDownloading(event);
                    break;
                }
                case ARTIFACT_INSTALLED: {
                    listener.artifactInstalled(event);
                    break;
                }
                case ARTIFACT_INSTALLING: {
                    listener.artifactInstalling(event);
                    break;
                }
                case ARTIFACT_RESOLVED: {
                    listener.artifactResolved(event);
                    break;
                }
                case ARTIFACT_RESOLVING: {
                    listener.artifactResolving(event);
                    break;
                }
                case METADATA_DEPLOYED: {
                    listener.metadataDeployed(event);
                    break;
                }
                case METADATA_DEPLOYING: {
                    listener.metadataDeploying(event);
                    break;
                }
                case METADATA_DOWNLOADED: {
                    listener.metadataDownloaded(event);
                    break;
                }
                case METADATA_DOWNLOADING: {
                    listener.metadataDownloading(event);
                    break;
                }
                case METADATA_INSTALLED: {
                    listener.metadataInstalled(event);
                    break;
                }
                case METADATA_INSTALLING: {
                    listener.metadataInstalling(event);
                    break;
                }
                case METADATA_INVALID: {
                    listener.metadataInvalid(event);
                    break;
                }
                case METADATA_RESOLVED: {
                    listener.metadataResolved(event);
                    break;
                }
                case METADATA_RESOLVING: {
                    listener.metadataResolving(event);
                    break;
                }
                default: {
                    throw new IllegalStateException("io.quarkus.launcher.shaded.unknown repository event type " + (Object)((Object)event.getType()));
                }
            }
        }
        catch (Exception | LinkageError e) {
            this.logError(e, listener);
        }
    }

    private void logError(Throwable e, Object listener) {
        String msg = "io.quarkus.launcher.shaded.Failed to dispatch repository event to " + listener.getClass().getCanonicalName() + "io.quarkus.launcher.shaded.: " + e.getMessage();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.warn(msg, e);
        } else {
            LOGGER.warn(msg);
        }
    }
}

